/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jdom.Element;

public class ProjectViewContextProvider
extends WorkingContextProvider {
    private final AbstractProjectViewPane[] myPanes;

    public ProjectViewContextProvider(Project project) {
        this.myPanes = (AbstractProjectViewPane[])Extensions.getExtensions((ExtensionPointName)AbstractProjectViewPane.EP_NAME, (AreaInstance)project);
    }

    public String getId() {
        return "projectView";
    }

    public String getDescription() {
        return "Project view state";
    }

    public void saveContext(Element toElement) throws WriteExternalException {
        for (AbstractProjectViewPane pane : this.myPanes) {
            Element paneElement = new Element(pane.getId());
            pane.writeExternal(paneElement);
            toElement.addContent(paneElement);
        }
    }

    public void loadContext(Element fromElement) throws InvalidDataException {
        for (AbstractProjectViewPane pane : this.myPanes) {
            Element paneElement = fromElement.getChild(pane.getId());
            if (paneElement == null) continue;
            pane.readExternal(paneElement);
            if (pane.getTree() == null) continue;
            pane.restoreExpandedPaths();
        }
    }

    public void clearContext() {
        for (AbstractProjectViewPane pane : this.myPanes) {
            JTree tree = pane.getTree();
            if (tree == null) continue;
            TreeUtil.collapseAll((JTree)tree, (int)-1);
        }
    }
}

