/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.tasks.Task;
import com.intellij.tasks.context.ContextInfo;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;

public class WorkingContextManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.context.WorkingContextManager");
    @NonNls
    private static final String TASKS_FOLDER = "tasks";
    private final Project myProject;
    @NonNls
    private static final String TASKS_ZIP_POSTFIX = ".tasks.zip";
    @NonNls
    private static final String TASK_XML_POSTFIX = ".task.xml";
    private static final String CONTEXT_ZIP_POSTFIX = ".contexts.zip";
    private static final Comparator<JBZipEntry> ENTRY_COMPARATOR = new Comparator<JBZipEntry>(){

        @Override
        public int compare(JBZipEntry o1, JBZipEntry o2) {
            return Long.signum(o2.getTime() - o1.getTime());
        }
    };

    public static WorkingContextManager getInstance(Project project) {
        return (WorkingContextManager)ServiceManager.getService((Project)project, WorkingContextManager.class);
    }

    public WorkingContextManager(Project project) {
        this.myProject = project;
    }

    public void loadContext(Element fromElement) {
        for (WorkingContextProvider provider : (WorkingContextProvider[])Extensions.getExtensions((ExtensionPointName)WorkingContextProvider.EP_NAME, (AreaInstance)this.myProject)) {
            try {
                Element child = fromElement.getChild(provider.getId());
                if (child == null) continue;
                provider.loadContext(child);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void saveContext(Element toElement) {
        for (WorkingContextProvider provider : (WorkingContextProvider[])Extensions.getExtensions((ExtensionPointName)WorkingContextProvider.EP_NAME, (AreaInstance)this.myProject)) {
            try {
                Element child = new Element(provider.getId());
                provider.saveContext(child);
                toElement.addContent(child);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void clearContext() {
        for (WorkingContextProvider provider : (WorkingContextProvider[])Extensions.getExtensions((ExtensionPointName)WorkingContextProvider.EP_NAME, (AreaInstance)this.myProject)) {
            provider.clearContext();
        }
    }

    public void saveContext(Task task) {
        String entryName = task.getId() + TASK_XML_POSTFIX;
        this.saveContext(entryName, TASKS_ZIP_POSTFIX, task.getSummary());
    }

    public void saveContext(String entryName, String comment) {
        this.saveContext(entryName, CONTEXT_ZIP_POSTFIX, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveContext(String entryName, String zipPostfix, String comment) {
        JBZipFile archive = null;
        try {
            archive = this.getTasksArchive(zipPostfix);
            if (entryName == null) {
                int i = archive.getEntries().size();
                do {
                    entryName = "context" + i++;
                } while (archive.getEntry("/" + entryName) != null);
            }
            JBZipEntry entry = archive.getOrCreateEntry("/" + entryName);
            if (comment != null) {
                entry.setComment(comment);
            }
            Element element = new Element("context");
            this.saveContext(element);
            String s = new XMLOutputter().outputString(element);
            entry.setData(s.getBytes(CharsetToolkit.UTF8_CHARSET));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            WorkingContextManager.closeArchive(archive);
        }
    }

    private JBZipFile getTasksArchive(String postfix) throws IOException {
        File file = this.getArchiveFile(postfix);
        try {
            return new JBZipFile(file);
        }
        catch (IOException e) {
            file.delete();
            JBZipFile zipFile = null;
            try {
                zipFile = new JBZipFile(file);
                Notifications.Bus.notify((Notification)new Notification("Tasks", "Context Data Corrupted", "Context information history for " + this.myProject.getName() + " was corrupted.\n" + "The history was replaced with empty one.", NotificationType.ERROR), (Project)this.myProject);
            }
            catch (IOException e1) {
                LOG.error("Can't repair form context data corruption", (Throwable)e1);
            }
            return zipFile;
        }
    }

    private File getArchiveFile(String postfix) {
        File tasksFolder = new File(PathManager.getConfigPath(), TASKS_FOLDER);
        if (!tasksFolder.exists()) {
            tasksFolder.mkdirs();
        }
        String projectName = FileUtil.sanitizeFileName((String)this.myProject.getName());
        return new File(tasksFolder, projectName + postfix);
    }

    public void restoreContext(Task task) {
        this.loadContext(TASKS_ZIP_POSTFIX, task.getId() + TASK_XML_POSTFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean loadContext(String zipPostfix, String entryName) {
        JBZipFile archive = null;
        try {
            archive = this.getTasksArchive(zipPostfix);
            JBZipEntry entry = archive.getEntry(StringUtil.startsWithChar((CharSequence)entryName, (char)'/') ? entryName : "/" + entryName);
            if (entry != null) {
                byte[] bytes = entry.getData();
                Document document = JDOMUtil.loadDocument((CharSequence)new String(bytes));
                Element rootElement = document.getRootElement();
                this.loadContext(rootElement);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            WorkingContextManager.closeArchive(archive);
        }
        return false;
    }

    private static void closeArchive(JBZipFile archive) {
        if (archive != null) {
            try {
                archive.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public List<ContextInfo> getContextHistory() {
        return this.getContextHistory(CONTEXT_ZIP_POSTFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<ContextInfo> getContextHistory(String zipPostfix) {
        JBZipFile archive = null;
        try {
            archive = this.getTasksArchive(zipPostfix);
            List entries = archive.getEntries();
            List list = ContainerUtil.mapNotNull((Collection)entries, (Function)new NullableFunction<JBZipEntry, ContextInfo>(){

                public ContextInfo fun(JBZipEntry entry) {
                    return entry.getName().startsWith("/context") ? new ContextInfo(entry.getName(), entry.getTime(), entry.getComment()) : null;
                }
            });
            return list;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            List<ContextInfo> list = Collections.emptyList();
            return list;
        }
        finally {
            WorkingContextManager.closeArchive(archive);
        }
    }

    public boolean loadContext(String name) {
        return this.loadContext(CONTEXT_ZIP_POSTFIX, name);
    }

    public void removeContext(String name) {
        this.removeContext(name, CONTEXT_ZIP_POSTFIX);
    }

    public void removeContext(Task task) {
        this.removeContext(task.getId(), TASKS_ZIP_POSTFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContext(String name, String postfix) {
        JBZipFile archive = null;
        try {
            archive = this.getTasksArchive(postfix);
            JBZipEntry entry = archive.getEntry(name);
            if (entry != null) {
                archive.eraseEntry(entry);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            WorkingContextManager.closeArchive(archive);
        }
    }

    public void pack(int max, int delta) {
        this.pack(max, delta, CONTEXT_ZIP_POSTFIX);
        this.pack(max, delta, TASKS_ZIP_POSTFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void pack(int max, int delta, String zipPostfix) {
        JBZipFile archive = null;
        try {
            archive = this.getTasksArchive(zipPostfix);
            List entries = archive.getEntries();
            if (entries.size() > max + delta) {
                JBZipEntry[] array = entries.toArray(new JBZipEntry[entries.size()]);
                Arrays.sort(array, ENTRY_COMPARATOR);
                for (int i = array.length - 1; i >= max; --i) {
                    archive.eraseEntry(array[i]);
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            WorkingContextManager.closeArchive(archive);
        }
    }

    public File getContextFile() throws IOException {
        return this.getArchiveFile(CONTEXT_ZIP_POSTFIX);
    }
}

