/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.generic.Selector;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class HighlightedSelectorsTable
extends TableView<Selector> {
    public HighlightedSelectorsTable(final FileType valueFileType, final Project project, List<Selector> selectors) {
        super(new ListTableModel(new ColumnInfo[]{new ColumnInfo<Selector, String>("Name"){

            public String valueOf(Selector selector) {
                return selector.getName();
            }
        }, new ColumnInfo<Selector, String>("Path"){

            public String valueOf(Selector selector) {
                return selector.getPath();
            }

            public boolean isCellEditable(Selector selector) {
                return true;
            }

            public void setValue(Selector selector, String value) {
                selector.setPath(value);
            }

            public TableCellRenderer getRenderer(Selector selector) {
                return new EditorTableCellViewer(valueFileType, project);
            }

            public TableCellEditor getEditor(Selector o) {
                return new EditorTableCellViewer(valueFileType, project);
            }
        }}, selectors, 0));
    }

    private static class EditorTableCellViewer
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private final EditorTextField myEditorField;

        private EditorTableCellViewer(FileType fileType, Project project) {
            this.myEditorField = new EditorTextField("", project, fileType);
        }

        public Object getCellEditorValue() {
            return this.myEditorField.getText();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myEditorField.setText((String)value);
            return this.myEditorField;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myEditorField.setText((String)value);
            return this.myEditorField;
        }
    }
}

