/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NonNls;

public class TemplateVariable {
    private String myName;
    private String myValue = "";
    private String myDescription = "";
    private boolean myReadOnly;
    private boolean myHidden;
    private boolean myShownOnFirstTab;

    public TemplateVariable(@NonNls String name, @NonNls String value) {
        this.myName = name;
        this.myValue = String.valueOf(value);
        this.myReadOnly = false;
        this.myDescription = "";
    }

    public TemplateVariable() {
    }

    private TemplateVariable(TemplateVariable other) {
        this.myName = other.getName();
        this.myValue = other.getValue();
        this.myDescription = other.getDescription();
        this.myHidden = other.isHidden();
        this.myReadOnly = other.isReadOnly();
        this.myShownOnFirstTab = other.isShownOnFirstTab();
    }

    public void setName(@NonNls String name) {
        this.myName = name;
    }

    public void setValue(@NonNls String value) {
        this.myValue = value;
    }

    public String getName() {
        return this.myName;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NonNls String description) {
        this.myDescription = description;
    }

    @Attribute(value="readOnly")
    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    @Attribute(value="hidden")
    public boolean isHidden() {
        return this.myHidden;
    }

    public void setHidden(boolean hidden) {
        this.myHidden = hidden;
    }

    @Attribute(value="shownOnFirstTab")
    public boolean isShownOnFirstTab() {
        return this.myShownOnFirstTab;
    }

    public void setShownOnFirstTab(boolean shownOnFirstTab) {
        this.myShownOnFirstTab = shownOnFirstTab;
    }

    public TemplateVariable clone() {
        return new TemplateVariable(this);
    }

    public String toString() {
        return String.format("TemplateVariable(name='%s', value='%s')", this.getName(), this.getValue());
    }

    public static abstract class FactoryVariable
    extends TemplateVariable {
        protected FactoryVariable(@NonNls String name) {
            this(name, false);
        }

        public FactoryVariable(@NonNls String name, boolean hidden) {
            super(name, "");
            this.setHidden(hidden);
        }

        @Override
        public abstract String getValue();

        @Override
        public final void setName(String name) {
            throw new UnsupportedOperationException("Name of predefined variable can't be changed");
        }

        @Override
        public final void setValue(String value) {
            throw new UnsupportedOperationException("Value of predefined variable can't be changed explicitly");
        }

        @Override
        public final void setShownOnFirstTab(boolean shownOnFirstTab) {
            throw new UnsupportedOperationException("This parameter can't be changed for predefined variable");
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            throw new UnsupportedOperationException("This parameter can't be changed for predefined variable");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

