/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.util.Comparing;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.gitlab.GitlabTask;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.impl.gson.GsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.ResponseUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NonNls;

@Tag(value="Gitlab")
public class GitlabRepository
extends NewBaseRepositoryImpl {
    @NonNls
    public static final String REST_API_PATH_PREFIX = "/api/v3/";
    private static final Pattern ID_PATTERN = Pattern.compile("\\d+");
    public static final Gson GSON = GsonUtil.createDefaultBuilder().create();
    public static final TypeToken<List<GitlabProject>> LIST_OF_PROJECTS_TYPE = new TypeToken<List<GitlabProject>>(){};
    public static final TypeToken<List<GitlabIssue>> LIST_OF_ISSUES_TYPE = new TypeToken<List<GitlabIssue>>(){};
    public static final GitlabProject UNSPECIFIED_PROJECT = new GitlabProject(){

        @Override
        public String getName() {
            return "-- from all projects --";
        }

        @Override
        public int getId() {
            return -1;
        }
    };
    private GitlabProject myCurrentProject;
    private List<GitlabProject> myProjects = null;

    public GitlabRepository() {
    }

    public GitlabRepository(TaskRepositoryType type) {
        super(type);
    }

    public GitlabRepository(GitlabRepository other) {
        super(other);
        this.myCurrentProject = other.myCurrentProject;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GitlabRepository repository = (GitlabRepository)((Object)o);
        return Comparing.equal((Object)this.myCurrentProject, (Object)repository.myCurrentProject);
    }

    public GitlabRepository clone() {
        return new GitlabRepository(this);
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed) throws Exception {
        return (Task[])ContainerUtil.map2Array(this.fetchIssues(offset / limit + 1, limit), GitlabTask.class, (Function)new Function<GitlabIssue, GitlabTask>(){

            public GitlabTask fun(GitlabIssue issue) {
                return new GitlabTask(GitlabRepository.this, issue);
            }
        });
    }

    public Task findTask(String id) throws Exception {
        return null;
    }

    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection(this, (HttpRequestBase)new HttpGet(this.getIssuesUrl()));
    }

    public List<GitlabProject> fetchProjects() throws Exception {
        ResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject> handler = new ResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject>(GSON, LIST_OF_PROJECTS_TYPE);
        String projectUrl = this.getRestApiUrl("projects");
        ArrayList<GitlabProject> result = new ArrayList<GitlabProject>();
        int pageNum = 1;
        while (true) {
            URI paginatedProjectsUrl = new URIBuilder(projectUrl).addParameter("page", String.valueOf(pageNum)).addParameter("per_page", "30").build();
            List page = (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(paginatedProjectsUrl), handler);
            if (page.isEmpty()) break;
            result.addAll(page);
            ++pageNum;
        }
        this.myProjects = result;
        return Collections.unmodifiableList(this.myProjects);
    }

    public GitlabProject fetchProject(int id) throws Exception {
        HttpGet request = new HttpGet(this.getRestApiUrl("project", id));
        return (GitlabProject)this.getHttpClient().execute((HttpUriRequest)request, new ResponseUtil.GsonSingleObjectDeserializer<GitlabProject>(GSON, GitlabProject.class));
    }

    public List<GitlabIssue> fetchIssues(int pageNumber, int pageSize) throws Exception {
        this.ensureProjectsDiscovered();
        URI url = new URIBuilder(this.getIssuesUrl()).addParameter("page", String.valueOf(pageNumber)).addParameter("per_page", String.valueOf(pageSize)).build();
        ResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue> handler = new ResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue>(GSON, LIST_OF_ISSUES_TYPE);
        return (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(url), handler);
    }

    private String getIssuesUrl() {
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            return this.getRestApiUrl("projects", this.myCurrentProject.getId(), "issues");
        }
        return this.getRestApiUrl("issues");
    }

    public GitlabIssue fetchIssue(int id) throws Exception {
        this.ensureProjectsDiscovered();
        HttpGet request = new HttpGet(this.getRestApiUrl("issues", id));
        ResponseUtil.GsonSingleObjectDeserializer<GitlabIssue> handler = new ResponseUtil.GsonSingleObjectDeserializer<GitlabIssue>(GSON, GitlabIssue.class, true);
        return (GitlabIssue)this.getHttpClient().execute((HttpUriRequest)request, handler);
    }

    public String getPresentableName() {
        String name = this.getUrl();
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            name = name + "/" + this.myCurrentProject.getName();
        }
        return name;
    }

    public String extractId(String taskName) {
        return ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    public boolean isConfigured() {
        return super.isConfigured() && !this.myPassword.isEmpty();
    }

    @Override
    public String getRestApiPathPrefix() {
        return REST_API_PATH_PREFIX;
    }

    @Override
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader("PRIVATE-TOKEN", GitlabRepository.this.myPassword);
            }
        };
    }

    public void setCurrentProject(GitlabProject project) {
        this.myCurrentProject = project != null && project.getId() == -1 ? UNSPECIFIED_PROJECT : project;
    }

    public GitlabProject getCurrentProject() {
        return this.myCurrentProject;
    }

    public List<GitlabProject> getProjects() {
        try {
            this.ensureProjectsDiscovered();
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.myProjects);
    }

    private void ensureProjectsDiscovered() throws Exception {
        if (this.myProjects == null) {
            this.fetchProjects();
        }
    }

    @Transient
    public void setProjects(List<GitlabProject> projects) {
        this.myProjects = projects;
    }
}

