/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;

public class GitlabTask
extends Task {
    private final GitlabIssue myIssue;
    private final GitlabRepository myRepository;
    private final GitlabProject myProject;

    public GitlabTask(GitlabRepository repository, GitlabIssue issue) {
        this.myRepository = repository;
        this.myIssue = issue;
        GitlabProject project = null;
        for (GitlabProject p : this.myRepository.getProjects()) {
            if (p.getId() != this.myIssue.getProjectId()) continue;
            project = p;
        }
        this.myProject = project;
    }

    public String getId() {
        return String.valueOf(this.myIssue.getId());
    }

    public String getSummary() {
        return this.myIssue.getTitle();
    }

    public String getDescription() {
        return null;
    }

    public Comment[] getComments() {
        return Comment.EMPTY_ARRAY;
    }

    public Icon getIcon() {
        return TasksIcons.Gitlab;
    }

    public TaskType getType() {
        return TaskType.BUG;
    }

    public Date getUpdated() {
        return this.myIssue.getUpdatedAt();
    }

    public Date getCreated() {
        return this.myIssue.getCreatedAt();
    }

    public boolean isClosed() {
        return this.myIssue.getState().equals("closed");
    }

    public boolean isIssue() {
        return true;
    }

    public String getNumber() {
        return String.valueOf(this.myIssue.getLocalId());
    }

    public String getProject() {
        return this.myProject == null ? null : this.myProject.getName();
    }

    public String getIssueUrl() {
        if (this.myProject != null) {
            return this.myProject.getWebUrl() + "/issues/" + this.myIssue.getLocalId();
        }
        return null;
    }

    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

