/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.redmine;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.redmine.RedmineRepository;
import com.intellij.tasks.redmine.model.RedmineIssue;
import com.intellij.tasks.redmine.model.RedmineProject;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;

public class RedmineTask
extends Task {
    private final RedmineIssue myIssue;
    private final RedmineRepository myRepository;
    private final RedmineProject myProject;

    public RedmineTask(RedmineRepository repository, RedmineIssue issue) {
        this.myIssue = issue;
        this.myRepository = repository;
        RedmineProject project = null;
        for (RedmineProject p : repository.getProjects()) {
            if (issue.getProject() == null || p.getId() != issue.getProject().getId()) continue;
            project = p;
            break;
        }
        this.myProject = project;
    }

    public String getId() {
        return String.valueOf(this.myIssue.getId());
    }

    public String getSummary() {
        return this.myIssue.getSubject();
    }

    public String getDescription() {
        return this.myIssue.getDescription();
    }

    public Comment[] getComments() {
        return Comment.EMPTY_ARRAY;
    }

    public Icon getIcon() {
        return TasksIcons.Redmine;
    }

    public TaskType getType() {
        return TaskType.BUG;
    }

    public Date getUpdated() {
        return this.myIssue.getUpdated();
    }

    public Date getCreated() {
        return this.myIssue.getCreated();
    }

    public boolean isClosed() {
        String name = this.myIssue.getStatus().getName();
        return name.equals("Closed") || name.equals("Resolved");
    }

    public boolean isIssue() {
        return true;
    }

    public String getIssueUrl() {
        return this.myRepository.getRestApiUrl("issues", this.getId());
    }

    public String getNumber() {
        return this.getId();
    }

    public String getProject() {
        return this.myProject == null ? null : this.myProject.getIdentifier();
    }

    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

