/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.ResponseUtil;
import com.intellij.tasks.trello.TrelloTask;
import com.intellij.tasks.trello.TrelloUtil;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloList;
import com.intellij.tasks.trello.model.TrelloUser;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

@Tag(value="Trello")
public final class TrelloRepository
extends NewBaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(TrelloRepository.class);
    static final TrelloBoard UNSPECIFIED_BOARD = new TrelloBoard(){

        @Override
        public String getName() {
            return "-- from all boards --";
        }
    };
    static final TrelloList UNSPECIFIED_LIST = new TrelloList(){

        @Override
        public String getName() {
            return "-- from all lists --";
        }
    };
    private TrelloUser myCurrentUser;
    private TrelloBoard myCurrentBoard;
    private TrelloList myCurrentList;
    private boolean myIncludeAllCards;

    public TrelloRepository() {
    }

    public TrelloRepository(TaskRepositoryType type) {
        super(type);
    }

    public TrelloRepository(TrelloRepository other) {
        super(other);
        this.myCurrentUser = other.myCurrentUser;
        this.myCurrentBoard = other.myCurrentBoard;
        this.myCurrentList = other.myCurrentList;
        this.myIncludeAllCards = other.myIncludeAllCards;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TrelloRepository repository = (TrelloRepository)((Object)o);
        if (!Comparing.equal((Object)this.myCurrentUser, (Object)repository.myCurrentUser)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myCurrentBoard, (Object)repository.myCurrentBoard)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myCurrentList, (Object)repository.myCurrentList)) {
            return false;
        }
        return this.myIncludeAllCards == repository.myIncludeAllCards;
    }

    public BaseRepository clone() {
        return new TrelloRepository(this);
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed) throws Exception {
        List<TrelloCard> cards = this.fetchCards(offset + limit, withClosed);
        return (Task[])ContainerUtil.map2Array(cards, Task.class, (Function)new Function<TrelloCard, Task>(){

            public Task fun(TrelloCard card) {
                return new TrelloTask(card, (TaskRepository)TrelloRepository.this);
            }
        });
    }

    public Task findTask(String id) throws Exception {
        TrelloCard card = this.fetchCardById(id);
        return card != null ? new TrelloTask(card, (TaskRepository)this) : null;
    }

    public TrelloCard fetchCardById(String id) throws Exception {
        try {
            URIBuilder url = new URIBuilder(this.getRestApiUrl("cards", id)).addParameter("actions", "commentCard").addParameter("fields", "closed,desc,idMembers,idBoard,idList,idShort,labels,name,url,dateLastActivity");
            return this.executeMethod((HttpUriRequest)new HttpGet(url.build()), new ResponseUtil.GsonSingleObjectDeserializer<TrelloCard>(TrelloUtil.GSON, TrelloCard.class, true));
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    public TrelloUser getCurrentUser() {
        return this.myCurrentUser;
    }

    public void setCurrentUser(TrelloUser currentUser) {
        this.myCurrentUser = currentUser;
    }

    public TrelloBoard getCurrentBoard() {
        return this.myCurrentBoard;
    }

    public void setCurrentBoard(TrelloBoard board) {
        this.myCurrentBoard = board != null && board.getId().equals(UNSPECIFIED_BOARD.getId()) ? UNSPECIFIED_BOARD : board;
    }

    public TrelloList getCurrentList() {
        return this.myCurrentList;
    }

    public void setCurrentList(TrelloList list) {
        this.myCurrentList = list != null && list.getId().equals(UNSPECIFIED_LIST.getId()) ? UNSPECIFIED_LIST : list;
    }

    public String extractId(String taskName) {
        return TrelloUtil.TRELLO_ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    public TrelloUser fetchUserByToken() throws Exception {
        try {
            URIBuilder url = new URIBuilder(this.getRestApiUrl("members", "me")).addParameter("fields", "username");
            return (TrelloUser)ObjectUtils.assertNotNull((Object)this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUser.class));
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial user info", (Throwable)e);
            this.myCurrentBoard = null;
            this.myCurrentList = null;
            throw e;
        }
    }

    public TrelloBoard fetchBoardById(String id) throws Exception {
        URIBuilder url = new URIBuilder(this.getRestApiUrl("boards", id)).addParameter("fields", "closed,name,idOrganization");
        try {
            return (TrelloBoard)ObjectUtils.assertNotNull((Object)this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloBoard.class));
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial board info", (Throwable)e);
            throw e;
        }
    }

    public TrelloList fetchListById(String id) throws Exception {
        URIBuilder url = new URIBuilder(this.getRestApiUrl("lists", id)).addParameter("fields", "closed,name,idBoard");
        try {
            return (TrelloList)ObjectUtils.assertNotNull((Object)this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloList.class));
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial list info" + id, (Throwable)e);
            throw e;
        }
    }

    public List<TrelloList> fetchBoardLists() throws Exception {
        if (this.myCurrentBoard == null || this.myCurrentBoard == UNSPECIFIED_BOARD) {
            throw new IllegalStateException("Board not set");
        }
        return this.fetchBoardLists(this.myCurrentBoard.getId());
    }

    private List<TrelloList> fetchBoardLists(String boardId) throws Exception {
        URIBuilder url = new URIBuilder(this.getRestApiUrl("boards", boardId, "lists")).addParameter("fields", "closed,name,idBoard");
        return this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUtil.LIST_OF_LISTS_TYPE);
    }

    public List<TrelloBoard> fetchUserBoards() throws Exception {
        if (this.myCurrentUser == null) {
            throw new IllegalStateException("User not set");
        }
        URIBuilder url = new URIBuilder(this.getRestApiUrl("members", "me", "boards")).addParameter("filter", "open").addParameter("fields", "closed,name,idOrganization");
        return this.makeRequestAndDeserializeJsonResponse(url.build(), TrelloUtil.LIST_OF_BOARDS_TYPE);
    }

    public List<TrelloCard> fetchCards(int limit, boolean withClosed) throws Exception {
        String baseUrl;
        boolean fromList = false;
        if (this.myCurrentList != null && this.myCurrentList != UNSPECIFIED_LIST) {
            baseUrl = this.getRestApiUrl("lists", this.myCurrentList.getId(), "cards");
            fromList = true;
        } else if (this.myCurrentBoard != null && this.myCurrentBoard != UNSPECIFIED_BOARD) {
            baseUrl = this.getRestApiUrl("boards", this.myCurrentBoard.getId(), "cards");
        } else if (this.myCurrentUser != null) {
            baseUrl = this.getRestApiUrl("members", "me", "cards");
        } else {
            throw new IllegalStateException("Not configured");
        }
        URIBuilder fetchCardUrl = new URIBuilder(baseUrl).addParameter("fields", "closed,desc,idMembers,idBoard,idList,idShort,labels,name,url,dateLastActivity").addParameter("limit", String.valueOf(limit));
        if (withClosed || fromList) {
            fetchCardUrl.addParameter("filter", "all");
        } else {
            fetchCardUrl.addParameter("filter", "visible");
        }
        List cards = this.makeRequestAndDeserializeJsonResponse(fetchCardUrl.build(), TrelloUtil.LIST_OF_CARDS_TYPE);
        LOG.debug("Total " + cards.size() + " cards downloaded");
        if (!this.myIncludeAllCards) {
            cards = ContainerUtil.filter(cards, (Condition)new Condition<TrelloCard>(){

                public boolean value(TrelloCard card) {
                    return card.getIdMembers().contains(TrelloRepository.this.myCurrentUser.getId());
                }
            });
            LOG.debug("Total " + cards.size() + " cards after filtering");
        }
        if (!cards.isEmpty()) {
            if (fromList) {
                baseUrl = this.getRestApiUrl("boards", ((TrelloCard)cards.get(0)).getIdBoard(), "cards");
            }
            URIBuilder visibleCardsUrl = new URIBuilder(baseUrl).addParameter("filter", "visible").addParameter("fields", "none");
            List<TrelloCard> visibleCards = this.makeRequestAndDeserializeJsonResponse(visibleCardsUrl.build(), TrelloUtil.LIST_OF_CARDS_TYPE);
            LOG.debug("Total " + visibleCards.size() + " visible cards");
            Set visibleCardsIDs = ContainerUtil.map2Set(visibleCards, (Function)new Function<TrelloCard, String>(){

                public String fun(TrelloCard card) {
                    return card.getId();
                }
            });
            for (TrelloCard card : cards) {
                card.setVisible(visibleCardsIDs.contains(card.getId()));
            }
        }
        return cards;
    }

    private <T> T executeMethod(HttpUriRequest method, ResponseHandler<T> handler) throws Exception {
        HttpClient client = this.getHttpClient();
        HttpResponse response = client.execute(method);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            Header header = response.getFirstHeader("Content-Type");
            if (header != null && header.getValue().startsWith("text/plain")) {
                String entityContent = ResponseUtil.getResponseContentAsString(response);
                throw new Exception(TaskBundle.message("failure.server.message", StringUtil.capitalize((String)entityContent)));
            }
            throw new Exception(TaskBundle.message("failure.http.error", statusLine.getStatusCode(), statusLine.getStatusCode()));
        }
        return (T)handler.handleResponse(response);
    }

    private <T> List<T> makeRequestAndDeserializeJsonResponse(URI url, TypeToken<List<T>> type) throws Exception {
        List result = (List)this.executeMethod((HttpUriRequest)new HttpGet(url), new ResponseUtil.GsonMultipleObjectsDeserializer<T>(TrelloUtil.GSON, type));
        return (List)ObjectUtils.assertNotNull((Object)result);
    }

    private <T> T makeRequestAndDeserializeJsonResponse(URI url, Class<T> cls) throws Exception {
        return this.executeMethod((HttpUriRequest)new HttpGet(url), new ResponseUtil.GsonSingleObjectDeserializer<T>(TrelloUtil.GSON, cls));
    }

    public String getPresentableName() {
        String pseudoUrl = "trello.com";
        if (this.myCurrentBoard != null && this.myCurrentBoard != UNSPECIFIED_BOARD) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentBoard.getName();
        }
        if (this.myCurrentList != null && this.myCurrentList != UNSPECIFIED_LIST) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentList.getName();
        }
        return pseudoUrl;
    }

    public boolean isIncludeAllCards() {
        return this.myIncludeAllCards;
    }

    public void setIncludeAllCards(boolean includeAllCards) {
        this.myIncludeAllCards = includeAllCards;
    }

    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet(this.getRestApiUrl("members", "me", "cards") + "?limit=1"));
    }

    @Override
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request instanceof HttpRequestWrapper) {
                    HttpRequestWrapper wrapper = (HttpRequestWrapper)request;
                    try {
                        wrapper.setURI(new URIBuilder(wrapper.getURI()).addParameter("token", TrelloRepository.this.myPassword).addParameter("key", "d6ec3709f7141007e150de64d4701181").build());
                    }
                    catch (URISyntaxException e) {
                        LOG.error("Illegal URL: " + wrapper.getURI(), (Throwable)e);
                    }
                } else {
                    LOG.error("Cannot add required authentication query parameters to request: " + request);
                }
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.myPassword);
    }

    @Override
    public String getRestApiPathPrefix() {
        return "/1";
    }

    public String getUrl() {
        return "https://api.trello.com";
    }

    public Set<CustomTaskState> getAvailableTaskStates(Task task) throws Exception {
        TrelloCard card = this.fetchCardById(task.getId());
        if (card != null) {
            List<TrelloList> lists = this.fetchBoardLists(card.getIdBoard());
            HashSet<CustomTaskState> result = new HashSet<CustomTaskState>();
            for (TrelloList list : lists) {
                if (list.getId().equals(card.getIdList())) continue;
                result.add(new CustomTaskState(list.getId(), list.getName()));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public void setTaskState(Task task, CustomTaskState state) throws Exception {
        URI url = new URIBuilder(this.getRestApiUrl("cards", task.getId(), "idList")).addParameter("value", state.getId()).build();
        HttpResponse response = this.getHttpClient().execute((HttpUriRequest)new HttpPut(url));
        if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 401 && EntityUtils.toString((HttpEntity)response.getEntity()).trim().equals("unauthorized card permission requested")) {
            throw new Exception(TaskBundle.message("trello.failure.write.access.required", new Object[0]));
        }
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF | 8;
    }
}

