/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello.model;

import com.google.gson.annotations.SerializedName;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import com.intellij.tasks.trello.model.TrelloLabel;
import com.intellij.tasks.trello.model.TrelloModel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class TrelloCard
extends TrelloModel {
    public static final String REQUIRED_FIELDS = "closed,desc,idMembers,idBoard,idList,idShort,labels,name,url,dateLastActivity";
    private String idBoard;
    private String idList;
    private String idShort;
    private List<String> idMembers;
    private String name;
    @SerializedName(value="desc")
    private String description;
    private String url;
    private boolean closed;
    private Date dateLastActivity;
    private List<TrelloLabel> labels;
    @SerializedName(value="actions")
    private List<TrelloCommentAction> comments = ContainerUtil.emptyList();
    private boolean isVisible = true;

    public String toString() {
        return String.format("TrelloCard(id='%s', name='%s')", this.getId(), this.name);
    }

    public String getIdBoard() {
        return this.idBoard;
    }

    public String getIdList() {
        return this.idList;
    }

    public String getIdShort() {
        return this.idShort;
    }

    public List<String> getIdMembers() {
        return this.idMembers;
    }

    @Override
    @Attribute(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public List<TrelloLabel> getLabels() {
        return this.labels;
    }

    public List<TrelloCommentAction> getComments() {
        return this.comments;
    }

    public Set<TrelloLabel.LabelColor> getColors() {
        if (this.labels == null || this.labels.isEmpty()) {
            return EnumSet.noneOf(TrelloLabel.LabelColor.class);
        }
        return EnumSet.copyOf(ContainerUtil.mapNotNull(this.labels, (Function)new Function<TrelloLabel, TrelloLabel.LabelColor>(){

            public TrelloLabel.LabelColor fun(TrelloLabel label) {
                TrelloLabel.LabelColor color = label.getColor();
                return color == TrelloLabel.LabelColor.NO_COLOR ? null : color;
            }
        }));
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public Date getDateLastActivity() {
        return this.dateLastActivity;
    }
}

