/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.util.GradleVersion;

public class DefaultConnectionParameters
implements ConnectionParameters {
    private final File gradleUserHomeDir;
    private final File projectDir;
    private final Boolean searchUpwards;
    private final Boolean embedded;
    private final Integer daemonMaxIdleTimeValue;
    private final TimeUnit daemonMaxIdleTimeUnits;
    private final File daemonBaseDir;
    private final boolean verboseLogging;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectionParameters connectionParameters) {
        return new Builder().setDaemonMaxIdleTimeUnits(connectionParameters.getDaemonMaxIdleTimeUnits()).setDaemonMaxIdleTimeValue(connectionParameters.getDaemonMaxIdleTimeValue()).setEmbedded(connectionParameters.isEmbedded()).setGradleUserHomeDir(connectionParameters.getGradleUserHomeDir()).setProjectDir(connectionParameters.getProjectDir()).setSearchUpwards(connectionParameters.isSearchUpwards()).setVerboseLogging(connectionParameters.getVerboseLogging());
    }

    private DefaultConnectionParameters(File gradleUserHomeDir, File projectDir, Boolean searchUpwards, Boolean embedded, Integer daemonMaxIdleTimeValue, TimeUnit daemonMaxIdleTimeUnits, File daemonBaseDir, boolean verboseLogging) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.projectDir = projectDir;
        this.searchUpwards = searchUpwards;
        this.embedded = embedded;
        this.daemonMaxIdleTimeValue = daemonMaxIdleTimeValue;
        this.daemonMaxIdleTimeUnits = daemonMaxIdleTimeUnits;
        this.daemonBaseDir = daemonBaseDir;
        this.verboseLogging = verboseLogging;
    }

    public File getDaemonBaseDir() {
        return this.daemonBaseDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public Boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public Boolean isEmbedded() {
        return this.embedded;
    }

    public Integer getDaemonMaxIdleTimeValue() {
        return this.daemonMaxIdleTimeValue;
    }

    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.daemonMaxIdleTimeUnits;
    }

    public String getConsumerVersion() {
        return GradleVersion.current().getVersion();
    }

    public boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    public static class Builder {
        private File gradleUserHomeDir;
        private File projectDir;
        private Boolean searchUpwards;
        private Boolean embedded;
        private Integer daemonMaxIdleTimeValue;
        private TimeUnit daemonMaxIdleTimeUnits;
        private boolean verboseLogging;
        private File daemonBaseDir;

        private Builder() {
        }

        public Builder setGradleUserHomeDir(File gradleUserHomeDir) {
            this.gradleUserHomeDir = gradleUserHomeDir;
            return this;
        }

        public Builder setProjectDir(File projectDir) {
            this.projectDir = projectDir;
            return this;
        }

        public Builder setSearchUpwards(Boolean searchUpwards) {
            this.searchUpwards = searchUpwards;
            return this;
        }

        public Builder setEmbedded(Boolean embedded) {
            this.embedded = embedded;
            return this;
        }

        public Builder setDaemonMaxIdleTimeValue(Integer daemonMaxIdleTimeValue) {
            this.daemonMaxIdleTimeValue = daemonMaxIdleTimeValue;
            return this;
        }

        public Builder setDaemonMaxIdleTimeUnits(TimeUnit daemonMaxIdleTimeUnits) {
            this.daemonMaxIdleTimeUnits = daemonMaxIdleTimeUnits;
            return this;
        }

        public Builder setVerboseLogging(boolean verboseLogging) {
            this.verboseLogging = verboseLogging;
            return this;
        }

        public DefaultConnectionParameters build() {
            return new DefaultConnectionParameters(this.gradleUserHomeDir, this.projectDir, this.searchUpwards, this.embedded, this.daemonMaxIdleTimeValue, this.daemonMaxIdleTimeUnits, this.daemonBaseDir, this.verboseLogging);
        }

        public void setDaemonBaseDir(File daemonBaseDir) {
            this.daemonBaseDir = daemonBaseDir;
        }
    }
}

