/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationResult;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.gradle.tooling.events.test.TestProgressListener;
import org.gradle.tooling.events.test.TestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultTestFailureResult;
import org.gradle.tooling.events.test.internal.DefaultTestFinishEvent;
import org.gradle.tooling.events.test.internal.DefaultTestSkippedResult;
import org.gradle.tooling.events.test.internal.DefaultTestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultTestSuccessResult;
import org.gradle.tooling.internal.consumer.DefaultFailure;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.events.InternalJvmTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalTestFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestResult;
import org.gradle.tooling.internal.protocol.events.InternalTestSkippedResult;
import org.gradle.tooling.internal.protocol.events.InternalTestStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestSuccessResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildProgressListenerAdapter
implements InternalBuildProgressListener {
    private final ListenerBroadcast<TestProgressListener> testProgressListeners = new ListenerBroadcast(TestProgressListener.class);
    private final Map<Object, TestOperationDescriptor> testDescriptorCache = new HashMap<Object, TestOperationDescriptor>();

    BuildProgressListenerAdapter(List<TestProgressListener> testListeners) {
        this.testProgressListeners.addAll(testListeners);
    }

    @Override
    public List<String> getSubscribedOperations() {
        return this.testProgressListeners.isEmpty() ? Collections.emptyList() : Collections.singletonList("TEST_EXECUTION");
    }

    @Override
    public void onEvent(Object event) {
        if (event instanceof InternalTestProgressEvent) {
            this.broadcastTestProgressEvent((InternalTestProgressEvent)event);
        }
    }

    private void broadcastTestProgressEvent(InternalTestProgressEvent event) {
        TestProgressEvent testProgressEvent = this.toTestProgressEvent(event);
        if (testProgressEvent != null) {
            ((TestProgressListener)this.testProgressListeners.getSource()).statusChanged(testProgressEvent);
        }
    }

    private synchronized TestProgressEvent toTestProgressEvent(InternalTestProgressEvent event) {
        if (event instanceof InternalTestStartedProgressEvent) {
            return this.testStartedEvent((InternalTestStartedProgressEvent)event);
        }
        if (event instanceof InternalTestFinishedProgressEvent) {
            return this.testFinishedEvent((InternalTestFinishedProgressEvent)event);
        }
        return null;
    }

    private TestStartEvent testStartedEvent(InternalTestStartedProgressEvent event) {
        long eventTime = event.getEventTime();
        String displayName = event.getDisplayName();
        TestOperationDescriptor testDescriptor = this.addTestDescriptor(event.getDescriptor());
        return new DefaultTestStartEvent(eventTime, displayName, testDescriptor);
    }

    private TestFinishEvent testFinishedEvent(InternalTestFinishedProgressEvent event) {
        long eventTime = event.getEventTime();
        String displayName = event.getDisplayName();
        TestOperationDescriptor testDescriptor = this.removeTestDescriptor(event.getDescriptor());
        TestOperationResult result = this.toTestResult(event.getResult());
        return new DefaultTestFinishEvent(eventTime, displayName, testDescriptor, result);
    }

    private TestOperationDescriptor addTestDescriptor(InternalTestDescriptor testDescriptor) {
        TestOperationDescriptor cachedTestDescriptor = this.testDescriptorCache.get(testDescriptor.getId());
        if (cachedTestDescriptor != null) {
            throw new IllegalStateException(String.format("Operation %s already available.", BuildProgressListenerAdapter.toString(testDescriptor)));
        }
        TestOperationDescriptor parent = this.getParentTestDescriptor(testDescriptor);
        TestOperationDescriptor newTestDescriptor = BuildProgressListenerAdapter.toTestDescriptor(testDescriptor, parent);
        this.testDescriptorCache.put(testDescriptor.getId(), newTestDescriptor);
        return newTestDescriptor;
    }

    private TestOperationDescriptor removeTestDescriptor(InternalTestDescriptor testDescriptor) {
        TestOperationDescriptor cachedTestDescriptor = this.testDescriptorCache.remove(testDescriptor.getId());
        if (cachedTestDescriptor == null) {
            throw new IllegalStateException(String.format("Operation %s is not available.", BuildProgressListenerAdapter.toString(testDescriptor)));
        }
        return cachedTestDescriptor;
    }

    private static TestOperationDescriptor toTestDescriptor(final InternalTestDescriptor testDescriptor, final TestOperationDescriptor parent) {
        if (testDescriptor instanceof InternalJvmTestDescriptor) {
            final InternalJvmTestDescriptor jvmTestDescriptor = (InternalJvmTestDescriptor)testDescriptor;
            return new JvmTestOperationDescriptor(){

                public String getName() {
                    return jvmTestDescriptor.getName();
                }

                public String getDisplayName() {
                    return jvmTestDescriptor.getDisplayName();
                }

                public JvmTestKind getJvmTestKind() {
                    return BuildProgressListenerAdapter.toJvmTestKind(jvmTestDescriptor);
                }

                public String getSuiteName() {
                    return jvmTestDescriptor.getSuiteName();
                }

                public String getClassName() {
                    return jvmTestDescriptor.getClassName();
                }

                public String getMethodName() {
                    return jvmTestDescriptor.getMethodName();
                }

                public TestOperationDescriptor getParent() {
                    return parent;
                }

                public String toString() {
                    return this.getDisplayName();
                }
            };
        }
        return new TestOperationDescriptor(){

            public String getName() {
                return testDescriptor.getName();
            }

            public String getDisplayName() {
                return testDescriptor.getDisplayName();
            }

            public TestOperationDescriptor getParent() {
                return parent;
            }

            public String toString() {
                return this.getDisplayName();
            }
        };
    }

    private static JvmTestKind toJvmTestKind(InternalJvmTestDescriptor jvmTestDescriptor) {
        String jvmTestKind = jvmTestDescriptor.getTestKind();
        if ("SUITE".equals(jvmTestKind)) {
            return JvmTestKind.SUITE;
        }
        if ("ATOMIC".equals(jvmTestKind)) {
            return JvmTestKind.ATOMIC;
        }
        return JvmTestKind.UNKNOWN;
    }

    private TestOperationResult toTestResult(InternalTestResult result) {
        if (result instanceof InternalTestSuccessResult) {
            return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestSkippedResult) {
            return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestFailureResult) {
            return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result));
        }
        return null;
    }

    private static List<Failure> toFailures(InternalTestResult testResult) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (InternalFailure internalFailure : testResult.getFailures()) {
            failures.add(BuildProgressListenerAdapter.toFailure(internalFailure));
        }
        return failures;
    }

    private static Failure toFailure(InternalFailure origFailure) {
        return origFailure == null ? null : new DefaultFailure(origFailure.getMessage(), origFailure.getDescription(), BuildProgressListenerAdapter.toFailure(origFailure.getCauses()));
    }

    private static List<Failure> toFailure(List<? extends InternalFailure> causes) {
        ArrayList<Failure> result = new ArrayList<Failure>();
        for (InternalFailure internalFailure : causes) {
            result.add(BuildProgressListenerAdapter.toFailure(internalFailure));
        }
        return result;
    }

    private TestOperationDescriptor getParentTestDescriptor(InternalTestDescriptor testDescriptor) {
        Object parentId = testDescriptor.getParentId();
        if (parentId == null) {
            return null;
        }
        TestOperationDescriptor parentTestDescriptor = this.testDescriptorCache.get(parentId);
        if (parentTestDescriptor == null) {
            throw new IllegalStateException(String.format("Parent test descriptor with id %s not available for %s.", parentId, BuildProgressListenerAdapter.toString(testDescriptor)));
        }
        return parentTestDescriptor;
    }

    private static String toString(InternalTestDescriptor testDescriptor) {
        if (testDescriptor instanceof InternalJvmTestDescriptor) {
            return String.format("TestOperationDescriptor[id(%s), name(%s), className(%s), parent(%s)]", testDescriptor.getId(), testDescriptor.getName(), ((InternalJvmTestDescriptor)testDescriptor).getClassName(), testDescriptor.getParentId());
        }
        return String.format("TestOperationDescriptor[id(%s), name(%s), parent(%s)]", testDescriptor.getId(), testDescriptor.getName(), testDescriptor.getParentId());
    }
}

