/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.api.ReadOnlyBaseConfig;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.SigningConfig;

public class ReadOnlyBuildType
extends ReadOnlyBaseConfig
implements BuildType {
    @NonNull
    private final BuildType buildType;
    @NonNull
    private final ReadOnlyObjectProvider readOnlyObjectProvider;

    public ReadOnlyBuildType(@NonNull BuildType buildType, @NonNull ReadOnlyObjectProvider readOnlyObjectProvider) {
        super((BaseConfig)buildType);
        this.buildType = buildType;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
    }

    public boolean isDebuggable() {
        return this.buildType.isDebuggable();
    }

    public boolean isTestCoverageEnabled() {
        return this.buildType.isTestCoverageEnabled();
    }

    public boolean isJniDebuggable() {
        return this.buildType.isJniDebuggable();
    }

    public boolean isPseudoLocalesEnabled() {
        return this.buildType.isPseudoLocalesEnabled();
    }

    public boolean isRenderscriptDebuggable() {
        return this.buildType.isRenderscriptDebuggable();
    }

    public int getRenderscriptOptimLevel() {
        return this.buildType.getRenderscriptOptimLevel();
    }

    @Nullable
    public String getApplicationIdSuffix() {
        return this.buildType.getApplicationIdSuffix();
    }

    @Nullable
    public String getVersionNameSuffix() {
        return this.buildType.getVersionNameSuffix();
    }

    public boolean isMinifyEnabled() {
        return this.buildType.isMinifyEnabled();
    }

    public boolean isZipAlignEnabled() {
        return this.buildType.isZipAlignEnabled();
    }

    public boolean isEmbedMicroApp() {
        return this.buildType.isEmbedMicroApp();
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.readOnlyObjectProvider.getSigningConfig(this.buildType.getSigningConfig());
    }
}

