/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.Immutable;
import com.android.builder.dependency.LibraryBundle;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Objects;
import java.io.File;
import java.util.Collections;
import java.util.List;

@Immutable
public class LibraryDependencyImpl
extends LibraryBundle {
    @NonNull
    private final List<LibraryDependency> dependencies;
    @Nullable
    private final String variantName;
    @Nullable
    private final MavenCoordinates requestedCoordinates;
    @Nullable
    private final MavenCoordinates resolvedCoordinates;

    public LibraryDependencyImpl(@NonNull File bundle, @NonNull File explodedBundle, @NonNull List<LibraryDependency> dependencies, @Nullable String name, @Nullable String variantName, @Nullable String projectPath, @Nullable MavenCoordinates requestedCoordinates, @Nullable MavenCoordinates resolvedCoordinates) {
        super(bundle, explodedBundle, name, projectPath);
        this.dependencies = dependencies;
        this.variantName = variantName;
        this.requestedCoordinates = requestedCoordinates;
        this.resolvedCoordinates = resolvedCoordinates;
    }

    @NonNull
    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.dependencies;
    }

    @NonNull
    public List<LibraryDependency> getDependencies() {
        return this.dependencies;
    }

    @NonNull
    public List<? extends ManifestDependency> getManifestDependencies() {
        return this.dependencies;
    }

    @Nullable
    public String getProjectVariant() {
        return this.variantName;
    }

    @Nullable
    public MavenCoordinates getRequestedCoordinates() {
        return this.requestedCoordinates;
    }

    @Nullable
    public MavenCoordinates getResolvedCoordinates() {
        return this.resolvedCoordinates;
    }

    @NonNull
    public LibraryDependencyImpl getNonTransitiveRepresentation() {
        return new LibraryDependencyImpl(this.getBundle(), this.getBundleFolder(), Collections.<LibraryDependency>emptyList(), this.getName(), this.variantName, this.getProject(), this.requestedCoordinates, this.resolvedCoordinates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibraryDependencyImpl that = (LibraryDependencyImpl)((Object)o);
        return Objects.equal(this.dependencies, that.dependencies) && Objects.equal((Object)this.variantName, (Object)that.variantName) && Objects.equal((Object)this.resolvedCoordinates, (Object)that.resolvedCoordinates);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.variantName, this.resolvedCoordinates});
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("dependencies", this.dependencies).add("variantName", (Object)this.variantName).add("requestedCoordinates", (Object)this.requestedCoordinates).add("resolvedCoordinates", (Object)this.resolvedCoordinates).add("super", (Object)super.toString()).toString();
    }
}

