/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.tasks.annotations.ApiDatabase;
import com.android.build.gradle.tasks.annotations.TypedefCollector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.xml.XmlEscapers;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Extractor {
    private static final boolean SORT_ANNOTATIONS = false;
    private static final boolean INCLUDE_TYPE_ARGS = false;
    private boolean includeClassRetentionAnnotations = false;
    private static final boolean INCLUDE_INFERRED_NULLABLE = false;
    public static final String ANDROID_ANNOTATIONS_PREFIX = "android.annotation.";
    public static final String ANDROID_NULLABLE = "android.annotation.Nullable";
    public static final String SUPPORT_NULLABLE = "android.support.annotation.Nullable";
    public static final String RESOURCE_TYPE_ANNOTATIONS_SUFFIX = "Res";
    public static final String ANDROID_NOTNULL = "android.annotation.NonNull";
    public static final String SUPPORT_NOTNULL = "android.support.annotation.NonNull";
    public static final String ANDROID_INT_DEF = "android.annotation.IntDef";
    public static final String ANDROID_STRING_DEF = "android.annotation.StringDef";
    public static final String IDEA_NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String IDEA_NOTNULL = "org.jetbrains.annotations.NotNull";
    public static final String IDEA_MAGIC = "org.intellij.lang.annotations.MagicConstant";
    public static final String IDEA_CONTRACT = "org.jetbrains.annotations.Contract";
    public static final String IDEA_NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String ATTR_VAL = "val";
    @NonNull
    private final Map<String, AnnotationData> types = Maps.newHashMap();
    @NonNull
    private final Set<String> irrelevantAnnotations = Sets.newHashSet();
    private final File classDir;
    @NonNull
    private Map<String, Map<String, List<Item>>> itemMap = Maps.newHashMap();
    @Nullable
    private final ApiDatabase apiFilter;
    private final boolean displayInfo;
    private Map<String, Integer> stats = Maps.newHashMap();
    private int filteredCount;
    private int mergedCount;
    private Set<CompilationUnitDeclaration> processedFiles = Sets.newHashSetWithExpectedSize((int)100);
    private Set<String> ignoredAnnotations = Sets.newHashSet();
    private boolean listIgnored;
    private Map<String, Annotation> typedefs;
    private List<File> classFiles;

    public Extractor(@Nullable ApiDatabase apiFilter, @Nullable File classDir, boolean displayInfo) {
        this.apiFilter = apiFilter;
        this.listIgnored = apiFilter != null;
        this.classDir = classDir;
        this.displayInfo = displayInfo;
    }

    public void extractFromProjectSource(Collection<CompilationUnitDeclaration> units) {
        TypedefCollector collector = new TypedefCollector(units, false, true);
        this.typedefs = collector.getTypedefs();
        this.classFiles = collector.getNonPublicTypedefClassFiles();
        for (CompilationUnitDeclaration unit : units) {
            this.analyze(unit);
        }
    }

    public void removeTypedefClasses() {
        if (this.classDir != null && this.classFiles != null && !this.classFiles.isEmpty()) {
            int count = 0;
            for (File file : this.classFiles) {
                if (!file.isAbsolute()) {
                    file = new File(this.classDir, file.getPath());
                }
                if (!file.exists()) continue;
                boolean deleted = file.delete();
                if (deleted) {
                    ++count;
                    continue;
                }
                Extractor.warning("Could not delete typedef class " + file.getPath());
            }
            this.info("Deleted " + count + " typedef annotation classes");
        }
    }

    public void export(@NonNull File output) {
        if (this.itemMap.isEmpty()) {
            if (output.exists()) {
                output.delete();
            }
        } else if (this.writeOutputFile(output)) {
            this.writeStats();
            this.info("Annotations written to " + output);
        }
    }

    public void writeStats() {
        if (!this.displayInfo) {
            return;
        }
        if (!this.stats.isEmpty()) {
            ArrayList annotations = Lists.newArrayList(this.stats.keySet());
            Collections.sort(annotations, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int frequency1 = (Integer)Extractor.this.stats.get(s1);
                    int frequency2 = (Integer)Extractor.this.stats.get(s2);
                    int delta = frequency2 - frequency1;
                    if (delta != 0) {
                        return delta;
                    }
                    return s1.compareTo(s2);
                }
            });
            HashMap fqnToName = Maps.newHashMap();
            int max = 0;
            int count = 0;
            for (String fqn : annotations) {
                String name = fqn.substring(fqn.lastIndexOf(46) + 1);
                fqnToName.put(fqn, name);
                max = Math.max(max, name.length());
                count += this.stats.get(fqn).intValue();
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("Extracted ").append(count).append(" Annotations:");
            for (String fqn : annotations) {
                sb.append('\n');
                String name = (String)fqnToName.get(fqn);
                int n = max - name.length() + 1;
                for (int i = 0; i < n; ++i) {
                    sb.append(' ');
                }
                sb.append('@');
                sb.append(name);
                sb.append(':').append(' ');
                sb.append(Integer.toString(this.stats.get(fqn)));
            }
            if (sb.length() > 0) {
                this.info(sb.toString());
            }
        }
        if (this.filteredCount > 0) {
            this.info(this.filteredCount + " of these were filtered out (not in API database file)");
        }
        if (this.mergedCount > 0) {
            this.info(this.mergedCount + " additional annotations were merged in");
        }
    }

    void info(String message) {
        if (this.displayInfo) {
            System.out.println(message);
        }
    }

    static void error(String message) {
        System.err.println("Error: " + message);
    }

    static void warning(String message) {
        System.out.println("Warning: " + message);
    }

    private void analyze(CompilationUnitDeclaration unit) {
        if (this.processedFiles.contains(unit)) {
            return;
        }
        this.processedFiles.add(unit);
        AnnotationVisitor visitor = new AnnotationVisitor();
        unit.traverse((ASTVisitor)visitor, unit.scope);
    }

    @Nullable
    private static ClassScope findClassScope(Scope scope) {
        while (scope != null) {
            if (scope instanceof ClassScope) {
                return (ClassScope)scope;
            }
            scope = scope.parent;
        }
        return null;
    }

    @Nullable
    static String getFqn(@NonNull Annotation annotation) {
        if (annotation.resolvedType != null) {
            return new String(annotation.resolvedType.readableName());
        }
        return null;
    }

    @Nullable
    private static String getFqn(@NonNull ClassScope scope) {
        TypeDeclaration typeDeclaration = scope.referenceType();
        if (typeDeclaration != null && typeDeclaration.binding != null) {
            return new String(typeDeclaration.binding.readableName());
        }
        return null;
    }

    @Nullable
    private static String getFqn(@NonNull MethodScope scope) {
        ClassScope classScope = Extractor.findClassScope((Scope)scope);
        if (classScope != null) {
            return Extractor.getFqn(classScope);
        }
        return null;
    }

    @Nullable
    private static String getFqn(@NonNull BlockScope scope) {
        ClassScope classScope = Extractor.findClassScope((Scope)scope);
        if (classScope != null) {
            return Extractor.getFqn(classScope);
        }
        return null;
    }

    static boolean hasSourceRetention(@NonNull Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            String typeName = Extractor.getFqn(annotation);
            if (!"java.lang.annotation.Retention".equals(typeName)) continue;
            MemberValuePair[] pairs = annotation.memberValuePairs();
            if (pairs == null || pairs.length != 1) {
                Extractor.warning("Expected exactly one parameter passed to @Retention");
                return false;
            }
            MemberValuePair pair = pairs[0];
            Expression value = pair.value;
            if (!(value instanceof NameReference)) continue;
            NameReference reference = (NameReference)value;
            Binding binding = reference.binding;
            if (binding == null || !(binding instanceof FieldBinding)) continue;
            FieldBinding fb = (FieldBinding)binding;
            if (!"SOURCE".equals(new String(fb.name)) || !"java.lang.annotation.RetentionPolicy".equals(new String(fb.declaringClass.readableName()))) continue;
            return true;
        }
        return false;
    }

    private void addAnnotations(@Nullable Annotation[] annotations, @NonNull Item item) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                AnnotationData annotationData = this.createAnnotation(annotation);
                if (annotationData == null) continue;
                item.annotations.add(annotationData);
            }
        }
    }

    @Nullable
    private AnnotationData createAnnotation(@NonNull Annotation annotation) {
        String fqn = Extractor.getFqn(annotation);
        if (fqn == null) {
            return null;
        }
        if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(SUPPORT_NULLABLE)) {
            this.recordStats(fqn);
            return new AnnotationData(SUPPORT_NULLABLE);
        }
        if (fqn.equals(ANDROID_NOTNULL) || fqn.equals(SUPPORT_NOTNULL)) {
            this.recordStats(fqn);
            return new AnnotationData(SUPPORT_NOTNULL);
        }
        if (fqn.startsWith("android.support.annotation.") && fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
            this.recordStats(fqn);
            return new AnnotationData(fqn);
        }
        if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
            if (fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
                String resAnnotation = "android.support.annotation." + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                this.recordStats(resAnnotation);
                return new AnnotationData(resAnnotation);
            }
            if (Extractor.isRelevantFrameworkAnnotation(fqn)) {
                String supportAnnotation = "android.support.annotation." + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                this.recordStats(supportAnnotation);
                return this.createData(supportAnnotation, annotation);
            }
        }
        if (fqn.startsWith("android.support.annotation.")) {
            this.recordStats(fqn);
            return this.createData(fqn, annotation);
        }
        if (this.isMagicConstant(fqn)) {
            return this.types.get(fqn);
        }
        return null;
    }

    private void recordStats(String fqn) {
        Integer count = this.stats.get(fqn);
        if (count == null) {
            count = 0;
        }
        this.stats.put(fqn, count + 1);
    }

    private boolean hasRelevantAnnotations(@Nullable Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            String fqn = Extractor.getFqn(annotation);
            if (fqn == null) continue;
            if (fqn.startsWith("android.support.annotation.")) {
                return this.includeClassRetentionAnnotations || !SUPPORT_NULLABLE.equals(fqn) && !SUPPORT_NOTNULL.equals(fqn);
            }
            if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
                return Extractor.isRelevantFrameworkAnnotation(fqn);
            }
            if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(ANDROID_NOTNULL) || this.isMagicConstant(fqn)) {
                return true;
            }
            if (!fqn.equals(IDEA_CONTRACT)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRelevantFrameworkAnnotation(@NonNull String fqn) {
        return fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX) && !fqn.endsWith(".Widget") && !fqn.endsWith(".TargetApi") && !fqn.endsWith(".SystemApi") && !fqn.endsWith(".SuppressLint") && !fqn.endsWith(".SdkConstant");
    }

    boolean isMagicConstant(String typeName) {
        AnnotationData a;
        String fqn;
        if (this.irrelevantAnnotations.contains(typeName) || typeName.startsWith("java.lang.")) {
            return false;
        }
        if (this.types.containsKey(typeName) || typeName.equals("android.support.annotation.IntDef") || typeName.equals("android.support.annotation.StringDef") || typeName.equals(ANDROID_INT_DEF) || typeName.equals(ANDROID_STRING_DEF)) {
            return true;
        }
        Annotation typeDef = this.typedefs.get(typeName);
        if (typeDef != null && (fqn = Extractor.getFqn(typeDef)) != null && (fqn.equals("android.support.annotation.IntDef") || fqn.equals("android.support.annotation.StringDef") || fqn.equals(ANDROID_INT_DEF) || fqn.equals(ANDROID_STRING_DEF)) && (a = this.createAnnotation(typeDef)) != null) {
            this.types.put(typeName, a);
            return true;
        }
        this.irrelevantAnnotations.add(typeName);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeOutputFile(File dest) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(dest);
            JarOutputStream zos = new JarOutputStream(fileOutputStream);
            try {
                ArrayList<String> sortedPackages = new ArrayList<String>(this.itemMap.keySet());
                Collections.sort(sortedPackages);
                Iterator i$ = sortedPackages.iterator();
                while (i$.hasNext()) {
                    String pkg = (String)i$.next();
                    String name = pkg.replace('.', '/') + "/annotations.xml";
                    JarEntry outEntry = new JarEntry(name);
                    zos.putNextEntry(outEntry);
                    StringWriter stringWriter = new StringWriter(1000);
                    PrintWriter writer = new PrintWriter(stringWriter);
                    try {
                        Document document;
                        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>");
                        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
                        ArrayList<String> classes = new ArrayList<String>(classMap.keySet());
                        Collections.sort(classes);
                        for (String cls : classes) {
                            List<Item> items = classMap.get(cls);
                            Collections.sort(items);
                            for (Item item : items) {
                                item.write(writer);
                            }
                        }
                        writer.println("</root>\n");
                        writer.close();
                        String xml = stringWriter.toString();
                        if (LintUtils.assertionsEnabled() && (document = Extractor.checkDocument(pkg, xml, false)) == null) {
                            Extractor.error("Could not parse XML document back in for entry " + name + ": invalid XML?\n\"\"\"\n" + xml + "\n\"\"\"\n");
                            boolean bl = false;
                            return bl;
                        }
                        byte[] bytes = xml.getBytes(Charsets.UTF_8);
                        zos.write(bytes);
                        zos.closeEntry();
                    }
                    finally {
                        writer.close();
                    }
                }
                return true;
            }
            finally {
                zos.flush();
                zos.close();
            }
        }
        catch (IOException ioe) {
            Extractor.error(ioe.toString());
            return false;
        }
    }

    private void addItem(@NonNull String fqn, @NonNull Item item) {
        List items;
        if (this.apiFilter != null && item.isFiltered(this.apiFilter)) {
            if (this.isListIgnored()) {
                this.info("Skipping API because it is not part of the API file: " + item);
            }
            ++this.filteredCount;
            return;
        }
        String pkg = Extractor.getPackage(fqn);
        HashMap classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            classMap = Maps.newHashMapWithExpectedSize((int)100);
            this.itemMap.put(pkg, classMap);
        }
        if ((items = (List)classMap.get(fqn)) == null) {
            items = Lists.newArrayList();
            classMap.put(fqn, items);
        }
        items.add(item);
    }

    private void removeItem(@NonNull String fqn, @NonNull Item item) {
        List<Item> items;
        String pkg = Extractor.getPackage(fqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap != null && (items = classMap.get(fqn)) != null) {
            items.remove(item);
            if (items.isEmpty()) {
                classMap.remove(fqn);
                if (classMap.isEmpty()) {
                    this.itemMap.remove(pkg);
                }
            }
        }
    }

    @Nullable
    private Item findItem(@NonNull String fqn, @NonNull Item item) {
        String pkg = Extractor.getPackage(fqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            return null;
        }
        List<Item> items = classMap.get(fqn);
        if (items == null) {
            return null;
        }
        for (Item existing : items) {
            if (!existing.equals(item)) continue;
            return existing;
        }
        return null;
    }

    @Nullable
    private static Document checkDocument(@NonNull String pkg, @NonNull String xml, boolean namespaceAware) {
        try {
            return XmlUtils.parseDocument((String)xml, (boolean)namespaceAware);
        }
        catch (SAXException sax) {
            Extractor.warning("Failed to parse document for package " + pkg + ": " + sax.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void mergeExisting(@NonNull File file) {
        block4: {
            block5: {
                block3: {
                    if (!file.isDirectory()) break block3;
                    File[] files = file.listFiles();
                    if (files == null) break block4;
                    for (File child : files) {
                        this.mergeExisting(child);
                    }
                    break block4;
                }
                if (!file.isFile()) break block4;
                if (!file.getPath().endsWith(".jar")) break block5;
                this.mergeFromJar(file);
                break block4;
            }
            if (!file.getPath().endsWith(".xml")) break block4;
            try {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                this.mergeAnnotationsXml(file.getPath(), xml);
            }
            catch (IOException e) {
                Extractor.error("Aborting: I/O problem during transform: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mergeFromJar(@NonNull File jar) {
        block12: {
            JarInputStream zis = null;
            FileInputStream fis = new FileInputStream(jar);
            zis = new JarInputStream(fis);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".xml")) {
                    byte[] bytes = ByteStreams.toByteArray((InputStream)zis);
                    String xml = new String(bytes, Charsets.UTF_8);
                    this.mergeAnnotationsXml(jar.getPath() + ": " + entry, xml);
                }
                entry = zis.getNextEntry();
            }
            try {
                Closeables.close((Closeable)zis, (boolean)true);
            }
            catch (IOException e) {}
            break block12;
            catch (IOException e) {
                try {
                    Extractor.error("Aborting: I/O problem during transform: " + e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(zis, (boolean)true);
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)zis, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void mergeAnnotationsXml(@NonNull String path, @NonNull String xml) {
        block2: {
            try {
                Document document = XmlUtils.parseDocument((String)xml, (boolean)false);
                this.mergeDocument(document);
            }
            catch (Exception e) {
                Extractor.warning("Failed to merge " + path + ": " + e.toString());
                if (e instanceof IOException) break block2;
                e.printStackTrace();
            }
        }
    }

    private void mergeDocument(@NonNull Document document) {
        Pattern XML_SIGNATURE = Pattern.compile("(\\S+) (\\S+|((.*)\\s+)?(\\S+)\\((.*)\\)( \\d+)?)");
        Element root = document.getDocumentElement();
        String rootTag = root.getTagName();
        assert (rootTag.equals("root")) : rootTag;
        for (Element item : Extractor.getChildren(root)) {
            Matcher matcher;
            String signature = item.getAttribute("name");
            if (signature == null || signature.equals("null") || !this.hasRelevantAnnotations(item)) continue;
            if ((signature = Extractor.unescapeXml(signature)).equals("java.util.Arrays void sort(T[], java.util.Comparator<?) 0")) {
                signature = "java.util.Arrays void sort(T[], java.util.Comparator<?>) 0";
            }
            if ((matcher = XML_SIGNATURE.matcher(signature)).matches()) {
                String methodName;
                String containingClass = matcher.group(1);
                if (containingClass == null) {
                    Extractor.warning("Could not find class for " + signature);
                }
                if ((methodName = matcher.group(5)) != null) {
                    String type = matcher.group(4);
                    boolean isConstructor = type == null;
                    String parameters = matcher.group(6);
                    this.mergeMethodOrParameter(item, matcher, containingClass, methodName, type, isConstructor, parameters);
                    continue;
                }
                String fieldName = matcher.group(2);
                this.mergeField(item, containingClass, fieldName);
                continue;
            }
            if (signature.indexOf(32) == -1 && signature.indexOf(46) != -1) continue;
            Extractor.warning("No merge match for signature " + signature);
        }
    }

    @NonNull
    private static String unescapeXml(@NonNull String escaped) {
        String workingString = escaped.replace("&quot;", "\"");
        workingString = workingString.replace("&lt;", "<");
        workingString = workingString.replace("&gt;", ">");
        workingString = workingString.replace("&apos;", "'");
        workingString = workingString.replace("&amp;", "&");
        return workingString;
    }

    @NonNull
    private static String escapeXml(@NonNull String unescaped) {
        return XmlEscapers.xmlAttributeEscaper().escape(unescaped);
    }

    private void mergeField(Element item, String containingClass, String fieldName) {
        if (this.apiFilter != null && !this.apiFilter.hasField(containingClass, fieldName)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + fieldName);
            }
            ++this.filteredCount;
        } else {
            FieldItem fieldItem = new FieldItem(containingClass, fieldName);
            Item existing = this.findItem(containingClass, fieldItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItem(containingClass, fieldItem);
                this.mergedCount += this.addAnnotations(item, (Item)fieldItem);
            }
        }
    }

    private void mergeMethodOrParameter(Element item, Matcher matcher, String containingClass, String methodName, String type, boolean constructor, String parameters) {
        parameters = Extractor.fixParameterString(parameters);
        if (this.apiFilter != null && !this.apiFilter.hasMethod(containingClass, methodName, parameters)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + methodName + "(" + parameters + ")");
            }
            ++this.filteredCount;
            return;
        }
        String argNum = matcher.group(7);
        if (argNum != null) {
            argNum = argNum.trim();
            ParameterItem parameterItem = new ParameterItem(containingClass, type, methodName, parameters, constructor, argNum);
            Item existing = this.findItem(containingClass, parameterItem);
            if ("java.util.Calendar".equals(containingClass) && "set".equals(methodName) && Integer.parseInt(argNum) > 0) {
                return;
            }
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItem(containingClass, parameterItem);
                this.mergedCount += this.addAnnotations(item, (Item)parameterItem);
            }
        } else {
            MethodItem methodItem = new MethodItem(containingClass, type, methodName, parameters, constructor);
            Item existing = this.findItem(containingClass, methodItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItem(containingClass, methodItem);
                this.mergedCount += this.addAnnotations(item, (Item)methodItem);
            }
        }
    }

    private static String fixParameterString(String parameters) {
        return parameters.replace("  ", " ").replace(", ", ",");
    }

    private boolean hasRelevantAnnotations(Element item) {
        for (Element annotationElement : Extractor.getChildren(item)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevantAnnotation(Element annotationElement) {
        AnnotationData annotation = this.createAnnotation(annotationElement);
        if (annotation == null) {
            return false;
        }
        if (Extractor.isNullable(annotation.name) || Extractor.isNonNull(annotation.name) || annotation.name.startsWith(ANDROID_ANNOTATIONS_PREFIX) || annotation.name.startsWith("android.support.annotation.")) {
            return true;
        }
        if (annotation.name.equals(IDEA_CONTRACT)) {
            return true;
        }
        if (annotation.name.equals(IDEA_NON_NLS)) {
            return false;
        }
        if (!this.ignoredAnnotations.contains(annotation.name)) {
            this.ignoredAnnotations.add(annotation.name);
            if (this.isListIgnored()) {
                this.info("(Ignoring merge annotation " + annotation.name + ")");
            }
        }
        return false;
    }

    @NonNull
    private static List<Element> getChildren(@NonNull Element element) {
        NodeList itemList = element.getChildNodes();
        int length = itemList.getLength();
        ArrayList<Element> result = new ArrayList<Element>(Math.max(5, length / 2 + 1));
        for (int i = 0; i < length; ++i) {
            Node node = itemList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    private int addAnnotations(Element itemElement, Item item) {
        int count = 0;
        for (Element annotationElement : Extractor.getChildren(itemElement)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            AnnotationData annotation = this.createAnnotation(annotationElement);
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private int mergeAnnotations(Element itemElement, Item item) {
        int count = 0;
        block0: for (Element annotationElement : Extractor.getChildren(itemElement)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            AnnotationData annotation = this.createAnnotation(annotationElement);
            boolean haveNullable = false;
            boolean haveNotNull = false;
            for (AnnotationData existing : item.annotations) {
                if (Extractor.isNonNull(existing.name)) {
                    haveNotNull = true;
                }
                if (Extractor.isNullable(existing.name)) {
                    haveNullable = true;
                }
                if (!existing.equals(annotation)) continue;
                continue block0;
            }
            if (Extractor.isNonNull(annotation.name) && haveNullable || Extractor.isNullable(annotation.name) && haveNotNull) {
                Extractor.warning("Found both @Nullable and @NonNull after import for " + item);
                continue;
            }
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private static boolean isNonNull(String name) {
        return name.equals(IDEA_NOTNULL) || name.equals(ANDROID_NOTNULL) || name.equals(SUPPORT_NOTNULL);
    }

    private static boolean isNullable(String name) {
        return name.equals(IDEA_NULLABLE) || name.equals(ANDROID_NULLABLE) || name.equals(SUPPORT_NULLABLE);
    }

    private AnnotationData createAnnotation(Element annotationElement) {
        AnnotationData annotation;
        String tagName = annotationElement.getTagName();
        assert (tagName.equals("annotation")) : tagName;
        String name = annotationElement.getAttribute("name");
        assert (name != null && !name.isEmpty());
        if (IDEA_MAGIC.equals(name)) {
            boolean flag;
            List<Element> children = Extractor.getChildren(annotationElement);
            assert (children.size() == 1) : children.size();
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flagsFromClass = valName.equals("flagsFromClass");
            boolean bl = flag = valName.equals("flags") || flagsFromClass;
            if (valName.equals("valuesFromClass") || flagsFromClass) {
                boolean found = false;
                if (value.endsWith(".class")) {
                    String clsName = value.substring(0, value.length() - ".class".length());
                    StringBuilder sb = new StringBuilder();
                    sb.append('{');
                    Field[] reflectionFields = null;
                    try {
                        Class<?> cls = Class.forName(clsName);
                        reflectionFields = cls.getDeclaredFields();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (this.apiFilter != null) {
                        HashSet fields = this.apiFilter.getDeclaredIntFields(clsName);
                        if ("java.util.zip.ZipEntry".equals(clsName)) {
                            fields = Sets.newHashSet((Object[])new String[]{"STORED", "DEFLATED"});
                        }
                        if (fields != null) {
                            ArrayList sorted = Lists.newArrayList(fields);
                            Collections.sort(sorted);
                            if (reflectionFields != null) {
                                int i;
                                final HashMap rank = Maps.newHashMap();
                                int n = sorted.size();
                                for (i = 0; i < n; ++i) {
                                    rank.put(sorted.get(i), reflectionFields.length + i);
                                }
                                n = reflectionFields.length;
                                for (i = 0; i < n; ++i) {
                                    rank.put(reflectionFields[i].getName(), i);
                                }
                                Collections.sort(sorted, new Comparator<String>(){

                                    @Override
                                    public int compare(String o1, String o2) {
                                        int rank2;
                                        int rank1 = (Integer)rank.get(o1);
                                        int delta = rank1 - (rank2 = ((Integer)rank.get(o2)).intValue());
                                        if (delta != 0) {
                                            return delta;
                                        }
                                        return o1.compareTo(o2);
                                    }
                                });
                            }
                            boolean first = true;
                            for (String field : sorted) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append(',').append(' ');
                                }
                                sb.append(clsName).append('.').append(field);
                            }
                            found = true;
                        }
                    }
                    if (!found && reflectionFields != null && (this.apiFilter == null || this.apiFilter.hasClass(clsName))) {
                        boolean first = true;
                        for (Field field : reflectionFields) {
                            if (field.getType() != Integer.TYPE && field.getType() != Integer.TYPE) continue;
                            if (first) {
                                first = false;
                            } else {
                                sb.append(',').append(' ');
                            }
                            sb.append(clsName).append('.').append(field.getName());
                        }
                    }
                    sb.append('}');
                    value = sb.toString();
                    if (sb.length() > 2) {
                        found = true;
                    }
                }
                if (!found) {
                    return null;
                }
            }
            if (this.apiFilter != null) {
                value = this.removeFiltered(value);
                while (value.contains(", ,")) {
                    value = value.replace(", ,", ",");
                }
                if (value.startsWith(", ")) {
                    value = value.substring(2);
                }
            }
            annotation = new AnnotationData(valName.equals("stringValues") ? "android.support.annotation.StringDef" : "android.support.annotation.IntDef", "value", value, flag ? "flag" : null, flag ? "true" : null);
        } else if ("android.support.annotation.StringDef".equals(name) || ANDROID_STRING_DEF.equals(name) || "android.support.annotation.IntDef".equals(name) || ANDROID_INT_DEF.equals(name)) {
            List<Element> children = Extractor.getChildren(annotationElement);
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            assert ("value".equals(valName));
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flag = false;
            if (children.size() == 2) {
                valueElement = children.get(1);
                assert ("flag".equals(valueElement.getAttribute("name")));
                flag = "true".equals(valueElement.getAttribute(ATTR_VAL));
            }
            boolean intDef = "android.support.annotation.IntDef".equals(name) || ANDROID_INT_DEF.equals(name);
            annotation = new AnnotationData(intDef ? "android.support.annotation.IntDef" : "android.support.annotation.StringDef", "value", value, flag ? "flag" : null, flag ? "true" : null);
        } else if (IDEA_CONTRACT.equals(name)) {
            List<Element> children = Extractor.getChildren(annotationElement);
            assert (children.size() == 1) : children.size();
            Element valueElement = children.get(0);
            String value = valueElement.getAttribute(ATTR_VAL);
            annotation = new AnnotationData(name, "value", value, null, null);
        } else if (Extractor.isNonNull(name)) {
            annotation = new AnnotationData(SUPPORT_NOTNULL);
        } else if (Extractor.isNullable(name)) {
            if (IDEA_NULLABLE.equals(name)) {
                return null;
            }
            annotation = new AnnotationData(SUPPORT_NULLABLE);
        } else {
            annotation = new AnnotationData(name, null, null);
        }
        return annotation;
    }

    private String removeFiltered(String value) {
        assert (this.apiFilter != null);
        if (value.startsWith("{")) {
            value = value.substring(1);
        }
        if (value.endsWith("}")) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.trim();
        StringBuilder sb = new StringBuilder(value.length());
        sb.append('{');
        for (String fqn : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
            String field;
            if ((fqn = Extractor.unescapeXml(fqn)).startsWith("\"")) continue;
            int index = fqn.lastIndexOf(46);
            String cls = fqn.substring(0, index);
            if (this.apiFilter.hasField(cls, field = fqn.substring(index + 1))) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(fqn);
                continue;
            }
            if (!this.isListIgnored()) continue;
            this.info("Skipping constant from typedef because it is not part of the SDK: " + fqn);
        }
        sb.append('}');
        return Extractor.escapeXml(sb.toString());
    }

    private static String getPackage(String fqn) {
        int index = 0;
        int last = 0;
        while ((index = fqn.indexOf(46, index)) != -1) {
            char next;
            last = index;
            if (index < fqn.length() - 1 && Character.isUpperCase(next = fqn.charAt(index + 1))) break;
            ++index;
        }
        return fqn.substring(0, last);
    }

    public void setListIgnored(boolean listIgnored) {
        this.listIgnored = listIgnored;
    }

    public boolean isListIgnored() {
        return this.listIgnored;
    }

    public void setIncludeClassRetentionAnnotations(boolean include) {
        this.includeClassRetentionAnnotations = include;
    }

    public AnnotationData createData(@NonNull String name, @NonNull Annotation annotation) {
        MemberValuePair[] pairs = annotation.memberValuePairs();
        if (pairs == null || pairs.length == 0) {
            return new AnnotationData(name);
        }
        return new AnnotationData(name, pairs);
    }

    @Nullable
    private static String getReturnType(MethodBinding binding) {
        if (binding.returnType != null) {
            return new String(binding.returnType.readableName());
        }
        if (binding.declaringClass != null) {
            assert (binding.isConstructor());
            return new String(binding.declaringClass.readableName());
        }
        return null;
    }

    @Nullable
    private static String getMethodName(@NonNull MethodBinding binding) {
        if (binding.isConstructor() && binding.declaringClass != null) {
            String classFqn = new String(binding.declaringClass.readableName());
            return classFqn.substring(classFqn.lastIndexOf(46) + 1);
        }
        if (binding.selector != null) {
            return new String(binding.selector);
        }
        assert (binding.isConstructor());
        return null;
    }

    @Nullable
    private static String getParameterList(@NonNull MethodBinding binding, boolean isVarargs) {
        StringBuilder sb = new StringBuilder();
        TypeBinding[] typeParameters = binding.parameters;
        if (typeParameters != null) {
            int n = typeParameters.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding parameter = typeParameters[i];
                if (i > 0) {
                    sb.append(',');
                }
                String str = Extractor.fixParameterString(new String(parameter.readableName()));
                if (isVarargs && i == n - 1 && str.endsWith("[]")) {
                    str = str.substring(0, str.length() - 2) + "...";
                }
                sb.append(str);
            }
        }
        return sb.toString();
    }

    class AnnotationVisitor
    extends ASTVisitor {
        AnnotationVisitor() {
        }

        public boolean visit(Argument argument, BlockScope scope) {
            ReferenceContext referenceContext;
            Annotation[] annotations = argument.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations) && (referenceContext = scope.referenceContext()) instanceof AbstractMethodDeclaration) {
                MethodBinding binding = ((AbstractMethodDeclaration)referenceContext).binding;
                String fqn = Extractor.getFqn(scope);
                ParameterItem item = ParameterItem.create((AbstractMethodDeclaration)referenceContext, argument, fqn, binding, argument.binding);
                if (item != null) {
                    Extractor.this.addItem(fqn, item);
                    Extractor.this.addAnnotations(annotations, item);
                }
            }
            return false;
        }

        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            Argument[] arguments;
            Annotation[] annotations = constructorDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                MethodBinding constructorBinding = constructorDeclaration.binding;
                if (constructorBinding == null) {
                    return false;
                }
                String fqn = Extractor.getFqn(scope);
                MethodItem item = MethodItem.create(fqn, (AbstractMethodDeclaration)constructorDeclaration, constructorBinding);
                if (item != null) {
                    Extractor.this.addItem(fqn, item);
                    Extractor.this.addAnnotations(annotations, item);
                }
            }
            if ((arguments = constructorDeclaration.arguments) != null) {
                for (Argument argument : arguments) {
                    argument.traverse((ASTVisitor)this, (BlockScope)constructorDeclaration.scope);
                }
            }
            return false;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            Annotation[] annotations = fieldDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                FieldBinding fieldBinding = fieldDeclaration.binding;
                if (fieldBinding == null) {
                    return false;
                }
                String fqn = Extractor.getFqn(scope);
                FieldItem item = FieldItem.create(fqn, fieldBinding);
                if (item != null) {
                    assert (fqn != null);
                    Extractor.this.addItem(fqn, item);
                    Extractor.this.addAnnotations(annotations, item);
                }
            }
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            Argument[] arguments;
            Annotation[] annotations = methodDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                MethodBinding methodBinding = methodDeclaration.binding;
                if (methodBinding == null) {
                    return false;
                }
                String fqn = Extractor.getFqn(scope);
                MethodItem item = MethodItem.create(fqn, (AbstractMethodDeclaration)methodDeclaration, methodDeclaration.binding);
                if (item != null) {
                    Extractor.this.addItem(fqn, item);
                    boolean skipReturnAnnotations = false;
                    if ("findViewById".equals(item.getName())) {
                        skipReturnAnnotations = true;
                        if (item.annotations.isEmpty()) {
                            Extractor.this.removeItem(fqn, item);
                        }
                    }
                    if (!skipReturnAnnotations) {
                        Extractor.this.addAnnotations(annotations, item);
                    }
                }
            }
            if ((arguments = methodDeclaration.arguments) != null) {
                for (Argument argument : arguments) {
                    argument.traverse((ASTVisitor)this, (BlockScope)methodDeclaration.scope);
                }
            }
            return false;
        }
    }

    private static class ParameterItem
    extends MethodItem {
        @NonNull
        public String argIndex;

        private ParameterItem(@NonNull String containingClass, @Nullable String returnType, @NonNull String methodName, @NonNull String parameterList, boolean isConstructor, @NonNull String argIndex) {
            super(containingClass, returnType, methodName, parameterList, isConstructor);
            this.argIndex = argIndex;
        }

        @Nullable
        static ParameterItem create(AbstractMethodDeclaration methodDeclaration, Argument argument, String classFqn, MethodBinding methodBinding, LocalVariableBinding parameterBinding) {
            if (classFqn == null || methodBinding == null || parameterBinding == null) {
                return null;
            }
            String methodName = Extractor.getMethodName(methodBinding);
            Argument[] arguments = methodDeclaration.arguments;
            boolean isVarargs = arguments != null && arguments.length > 0 && arguments[arguments.length - 1].isVarArgs();
            String parameterList = Extractor.getParameterList(methodBinding, isVarargs);
            String returnType = Extractor.getReturnType(methodBinding);
            if (methodName == null || parameterList == null || returnType == null) {
                return null;
            }
            int index = 0;
            boolean found = false;
            if (methodDeclaration.arguments != null) {
                for (Argument a : methodDeclaration.arguments) {
                    if (a == argument) {
                        found = true;
                        break;
                    }
                    ++index;
                }
            }
            if (!found) {
                return null;
            }
            String argNum = Integer.toString(index);
            classFqn = ApiDatabase.getRawClass(classFqn);
            methodName = ApiDatabase.getRawMethod(methodName);
            return new ParameterItem(classFqn, returnType, methodName, parameterList, methodBinding.isConstructor(), argNum);
        }

        @Override
        String getSignature() {
            return super.getSignature() + ' ' + this.argIndex;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ParameterItem that = (ParameterItem)o;
            return this.argIndex.equals(that.argIndex);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.argIndex.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "Parameter #" + this.argIndex + " in " + super.toString();
        }
    }

    private static class MethodItem
    extends Item {
        @NonNull
        public final String methodName;
        @NonNull
        public final String containingClass;
        @NonNull
        public final String parameterList;
        @Nullable
        public final String returnType;
        public final boolean isConstructor;

        private MethodItem(@NonNull String containingClass, @Nullable String returnType, @NonNull String methodName, @NonNull String parameterList, boolean isConstructor) {
            this.containingClass = containingClass;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterList = parameterList;
            this.isConstructor = isConstructor;
        }

        @NonNull
        public String getName() {
            return this.methodName;
        }

        @Nullable
        static MethodItem create(@Nullable String classFqn, @NonNull AbstractMethodDeclaration declaration, @Nullable MethodBinding binding) {
            if (classFqn == null || binding == null) {
                return null;
            }
            String returnType = Extractor.getReturnType(binding);
            String methodName = Extractor.getMethodName(binding);
            Argument[] arguments = declaration.arguments;
            boolean isVarargs = arguments != null && arguments.length > 0 && arguments[arguments.length - 1].isVarArgs();
            String parameterList = Extractor.getParameterList(binding, isVarargs);
            if (returnType == null || methodName == null || parameterList == null) {
                return null;
            }
            classFqn = ApiDatabase.getRawClass(classFqn);
            methodName = ApiDatabase.getRawMethod(methodName);
            return new MethodItem(classFqn, returnType, methodName, parameterList, binding.isConstructor());
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        String getSignature() {
            StringBuilder sb = new StringBuilder(100);
            sb.append(Extractor.escapeXml(this.containingClass));
            sb.append(' ');
            if (this.isConstructor) {
                sb.append(Extractor.escapeXml(this.methodName));
            } else {
                assert (this.returnType != null);
                sb.append(Extractor.escapeXml(this.returnType));
                sb.append(' ');
                sb.append(Extractor.escapeXml(this.methodName));
            }
            sb.append('(');
            int balance = 0;
            int n = this.parameterList.length();
            for (int i = 0; i < n; ++i) {
                char c = this.parameterList.charAt(i);
                if (c == '<') {
                    ++balance;
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    --balance;
                    sb.append("&gt;");
                    continue;
                }
                if (c == ',') {
                    sb.append(',');
                    if (balance != 0) continue;
                    sb.append(' ');
                    continue;
                }
                sb.append(c);
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        boolean isFiltered(@NonNull ApiDatabase database) {
            return !database.hasMethod(this.containingClass, this.methodName, this.parameterList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodItem that = (MethodItem)o;
            return this.isConstructor == that.isConstructor && this.containingClass.equals(that.containingClass) && this.methodName.equals(that.methodName) && this.parameterList.equals(that.parameterList);
        }

        public int hashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            result = 31 * result + this.parameterList.hashCode();
            result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
            result = 31 * result + (this.isConstructor ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Method " + this.containingClass + "#" + this.methodName;
        }
    }

    private static class FieldItem
    extends Item {
        @NonNull
        public final String fieldName;
        @NonNull
        public final String containingClass;

        private FieldItem(@NonNull String containingClass, @NonNull String fieldName) {
            this.containingClass = containingClass;
            this.fieldName = fieldName;
        }

        @Nullable
        static FieldItem create(String classFqn, FieldBinding field) {
            String name = new String(field.name);
            return classFqn != null ? new FieldItem(classFqn, name) : null;
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        boolean isFiltered(@NonNull ApiDatabase database) {
            return !database.hasField(this.containingClass, this.fieldName);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass) + ' ' + this.fieldName;
        }

        public String toString() {
            return "Field " + this.containingClass + "#" + this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldItem that = (FieldItem)o;
            return this.containingClass.equals(that.containingClass) && this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            return result;
        }
    }

    private static abstract class Item
    implements Comparable<Item> {
        public final List<AnnotationData> annotations = Lists.newArrayList();

        private Item() {
        }

        void write(PrintWriter writer) {
            if (!this.isValid()) {
                return;
            }
            writer.print("  <item name=\"");
            writer.print(this.getSignature());
            writer.println("\">");
            for (AnnotationData annotation : this.annotations) {
                annotation.write(writer);
            }
            writer.print("  </item>");
            writer.println();
        }

        abstract boolean isValid();

        abstract boolean isFiltered(@NonNull ApiDatabase var1);

        abstract String getSignature();

        @Override
        public int compareTo(@NonNull Item item) {
            String signature1 = this.getSignature();
            String signature2 = item.getSignature();
            signature1 = signature1.replace('&', '.');
            signature2 = signature2.replace('&', '.');
            return signature1.compareTo(signature2);
        }
    }

    private class AnnotationData {
        @NonNull
        public final String name;
        @Nullable
        public final String attributeName1;
        @Nullable
        public final String attributeValue1;
        @Nullable
        public final String attributeName2;
        @Nullable
        public final String attributeValue2;
        @Nullable
        public MemberValuePair[] attributes;

        private AnnotationData(String name) {
            this(name, null, null, null, null);
        }

        private AnnotationData(@Nullable String name, MemberValuePair[] pairs) {
            this(name, null, null, null, null);
            this.attributes = pairs;
            assert (this.attributes == null || this.attributes.length > 0);
        }

        private AnnotationData(@Nullable String name, @Nullable String attributeName, String attributeValue) {
            this(name, attributeName, attributeValue, null, null);
        }

        private AnnotationData(@Nullable String name, @Nullable String attributeName1, @Nullable String attributeValue1, @Nullable String attributeName2, String attributeValue2) {
            this.name = name;
            this.attributeName1 = attributeName1;
            this.attributeValue1 = attributeValue1;
            this.attributeName2 = attributeName2;
            this.attributeValue2 = attributeValue2;
        }

        void write(PrintWriter writer) {
            writer.print("    <annotation name=\"");
            writer.print(this.name);
            if (this.attributes != null) {
                writer.print("\">");
                writer.println();
                if (this.attributes.length > 1) {
                    // empty if block
                }
                for (MemberValuePair pair : this.attributes) {
                    writer.print("      <val name=\"");
                    if (pair.name != null) {
                        writer.print(pair.name);
                    } else {
                        writer.print("value");
                    }
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(this.attributeString(pair.value)));
                    writer.println("\" />");
                }
                writer.println("    </annotation>");
            } else if (this.attributeValue1 != null) {
                writer.print("\">");
                writer.println();
                writer.print("      <val name=\"");
                writer.print(this.attributeName1);
                writer.print("\" val=\"");
                writer.print(Extractor.escapeXml(this.attributeValue1));
                writer.println("\" />");
                if (this.attributeValue2 != null) {
                    writer.print("      <val name=\"");
                    writer.print(this.attributeName2);
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(this.attributeValue2));
                    writer.println("\" />");
                }
                writer.println("    </annotation>");
            } else {
                writer.println("\" />");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData that = (AnnotationData)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private String attributeString(@NonNull Expression value) {
            StringBuilder sb = new StringBuilder();
            this.appendExpression(sb, value);
            return sb.toString();
        }

        private boolean appendExpression(@NonNull StringBuilder sb, @NonNull Expression expression) {
            if (expression instanceof ArrayInitializer) {
                sb.append('{');
                ArrayInitializer initializer = (ArrayInitializer)expression;
                boolean first = true;
                int initialLength = sb.length();
                for (Expression e : initializer.expressions) {
                    int length = sb.length();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    boolean appended = this.appendExpression(sb, e);
                    if (appended) continue;
                    sb.setLength(length);
                    if (length != initialLength) continue;
                    first = true;
                }
                sb.append('}');
                return true;
            }
            if (expression instanceof NameReference) {
                NameReference reference = (NameReference)expression;
                if (reference.binding != null) {
                    if (reference.binding instanceof FieldBinding) {
                        FieldBinding fb = (FieldBinding)reference.binding;
                        if (fb.declaringClass != null) {
                            if (Extractor.this.apiFilter != null && !Extractor.this.apiFilter.hasField(new String(fb.declaringClass.readableName()), new String(fb.name))) {
                                if (Extractor.this.isListIgnored()) {
                                    Extractor.this.info("Filtering out typedef constant " + new String(fb.declaringClass.readableName()) + "." + new String(fb.name) + "");
                                }
                                return false;
                            }
                            sb.append(fb.declaringClass.readableName());
                            sb.append('.');
                            sb.append(fb.name);
                        } else {
                            sb.append(reference.binding.readableName());
                        }
                    } else {
                        sb.append(reference.binding.readableName());
                    }
                    return true;
                }
                Extractor.warning("No binding for reference " + reference);
                return false;
            }
            if (expression instanceof StringLiteral) {
                StringLiteral s = (StringLiteral)expression;
                sb.append('\"');
                sb.append(s.source());
                sb.append('\"');
                return true;
            }
            if (expression instanceof NumberLiteral) {
                NumberLiteral number = (NumberLiteral)expression;
                sb.append(number.source());
                return true;
            }
            if (expression instanceof TrueLiteral) {
                sb.append(true);
                return true;
            }
            if (expression instanceof FalseLiteral) {
                sb.append(false);
                return true;
            }
            if (expression instanceof NullLiteral) {
                sb.append("null");
                return true;
            }
            if (expression.constant != null) {
                if (expression.constant.typeID() == 10) {
                    sb.append(expression.constant.intValue());
                    return true;
                }
                if (expression.constant.typeID() == 11) {
                    sb.append('\"');
                    sb.append(expression.constant.stringValue());
                    sb.append('\"');
                    return true;
                }
                Extractor.warning("Unexpected type for constant " + expression.constant.toString());
            } else {
                Extractor.warning("Unexpected annotation expression of type " + expression.getClass() + " and is " + expression);
            }
            return false;
        }
    }
}

