/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.jetbrains.plugins.gradle.model.scala.ScalaModel;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaCompileOptionsImpl;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaForkOptionsImpl;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaModelImpl;

public class ScalaModelBuilderImpl
implements ModelBuilderService {
    private static final String COMPILE_SCALA_TASK = "compileScala";

    public boolean canBuild(String modelName) {
        return ScalaModel.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        ScalaPlugin scalaPlugin = (ScalaPlugin)project.getPlugins().findPlugin(ScalaPlugin.class);
        if (scalaPlugin == null) {
            return null;
        }
        ScalaModelImpl scalaModel = new ScalaModelImpl();
        for (Task task : project.getTasks()) {
            if (!(task instanceof ScalaCompile) || !COMPILE_SCALA_TASK.equals(task.getName())) continue;
            ScalaCompile scalaCompile = (ScalaCompile)task;
            scalaModel.setScalaClasspath(scalaCompile.getScalaClasspath().getFiles());
            scalaModel.setZincClasspath(scalaCompile.getZincClasspath().getFiles());
            scalaModel.setScalaCompileOptions(ScalaModelBuilderImpl.create(scalaCompile.getScalaCompileOptions()));
            scalaModel.setTargetCompatibility(scalaCompile.getTargetCompatibility());
            scalaModel.setSourceCompatibility(scalaCompile.getSourceCompatibility());
            break;
        }
        return scalaModel;
    }

    public ErrorMessageBuilder getErrorMessageBuilder(Project project, Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Scala import errors").withDescription("Unable to build Scala project configuration");
    }

    private static ScalaCompileOptionsImpl create(ScalaCompileOptions options) {
        if (options == null) {
            return null;
        }
        ScalaCompileOptionsImpl result = new ScalaCompileOptionsImpl();
        result.setAdditionalParameters(options.getAdditionalParameters());
        result.setDaemonServer(options.getDaemonServer());
        result.setDebugLevel(options.getDebugLevel());
        result.setDeprecation(options.isDeprecation());
        result.setEncoding(options.getEncoding());
        result.setFailOnError(options.isFailOnError());
        result.setForce(options.getForce());
        result.setFork(options.isFork());
        result.setForkOptions(ScalaModelBuilderImpl.create(options.getForkOptions()));
        result.setListFiles(options.isListFiles());
        result.setLoggingLevel(options.getLoggingLevel());
        result.setDebugLevel(options.getDebugLevel());
        result.setLoggingPhases(options.getLoggingPhases());
        result.setOptimize(options.isOptimize());
        result.setUnchecked(options.isUnchecked());
        result.setUseAnt(options.isUseAnt());
        result.setUseCompileDaemon(options.isUseCompileDaemon());
        return result;
    }

    private static ScalaForkOptionsImpl create(ScalaForkOptions forkOptions) {
        if (forkOptions == null) {
            return null;
        }
        ScalaForkOptionsImpl result = new ScalaForkOptionsImpl();
        result.setJvmArgs(forkOptions.getJvmArgs());
        result.setMemoryInitialSize(forkOptions.getMemoryInitialSize());
        result.setMemoryMaximumSize(forkOptions.getMemoryMaximumSize());
        return result;
    }
}

