/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.util.List;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.ShowStacktrace;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.BufferingStyledTextOutput;
import org.gradle.logging.internal.LinePrefixingStyledTextOutput;
import org.gradle.util.GUtil;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildExceptionReporter
extends BuildAdapter
implements Action<Throwable> {
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData) {
        this.textOutputFactory = textOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = clientMetaData;
    }

    @Override
    public void buildFinished(BuildResult result) {
        Throwable failure = result.getFailure();
        if (failure == null) {
            return;
        }
        this.execute(failure);
    }

    public void execute(Throwable failure) {
        if (failure instanceof MultipleBuildFailures) {
            this.renderMultipleBuildExceptions((MultipleBuildFailures)((Object)failure));
            return;
        }
        this.renderSingleBuildException(failure);
    }

    private void renderMultipleBuildExceptions(MultipleBuildFailures multipleFailures) {
        List causes = multipleFailures.getCauses();
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).format("FAILURE: Build completed with %s failures.", causes.size());
        output.println();
        for (int i = 0; i < causes.size(); ++i) {
            Throwable cause = (Throwable)causes.get(i);
            FailureDetails details = this.constructFailureDetails("Task", cause);
            output.println();
            output.withStyle(StyledTextOutput.Style.Failure).format("%s: ", i + 1);
            details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
            output.println();
            output.text("-----------");
            this.writeFailureDetails(output, details);
            output.println("==============================================================================");
        }
    }

    private void renderSingleBuildException(Throwable failure) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        FailureDetails details = this.constructFailureDetails("Build", failure);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text("FAILURE: ");
        details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
        output.println();
        this.writeFailureDetails(output, details);
    }

    private FailureDetails constructFailureDetails(String granularity, Throwable failure) {
        FailureDetails details = new FailureDetails(failure);
        this.reportBuildFailure(granularity, failure, details);
        return details;
    }

    private void reportBuildFailure(String granularity, Throwable failure, FailureDetails details) {
        if (this.loggingConfiguration.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            details.exceptionStyle = ExceptionStyle.FULL;
        }
        this.formatGenericFailure(granularity, failure, details);
    }

    private void formatGenericFailure(String granularity, Throwable failure, final FailureDetails details) {
        details.summary.format("%s failed with an exception.", granularity);
        this.fillInFailureResolution(details);
        if (failure instanceof LocationAwareException) {
            final LocationAwareException scriptException = (LocationAwareException)((Object)failure);
            details.failure = scriptException.getCause();
            if (scriptException.getLocation() != null) {
                details.location.text(scriptException.getLocation());
            }
            scriptException.visitReportableCauses((TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){
                int depth;

                @Override
                public void node(Throwable node) {
                    if (node == scriptException) {
                        details.details.text(BuildExceptionReporter.this.getMessage(scriptException.getCause()));
                    } else {
                        LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput();
                        output.text(BuildExceptionReporter.this.getMessage(node));
                    }
                }

                @Override
                public void startChildren() {
                    ++this.depth;
                }

                @Override
                public void endChildren() {
                    --this.depth;
                }

                private LinePrefixingStyledTextOutput getLinePrefixingStyledTextOutput() {
                    details.details.format("%n", new Object[0]);
                    StringBuilder prefix = new StringBuilder();
                    for (int i = 1; i < this.depth; ++i) {
                        prefix.append("   ");
                    }
                    details.details.text(prefix);
                    prefix.append("  ");
                    details.details.style(StyledTextOutput.Style.Info).text("> ").style(StyledTextOutput.Style.Normal);
                    return new LinePrefixingStyledTextOutput(details.details, prefix);
                }
            });
        } else {
            details.details.text(this.getMessage(failure));
        }
    }

    private void fillInFailureResolution(FailureDetails details) {
        if (details.failure instanceof FailureResolutionAware) {
            ((FailureResolutionAware)((Object)details.failure)).appendResolution(details.resolution, this.clientMetaData);
            if (details.resolution.getHasContent()) {
                details.resolution.append(' ');
            }
        }
        if (details.exceptionStyle == ExceptionStyle.NONE) {
            details.resolution.text("Run with ");
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "stacktrace");
            details.resolution.text(" option to get the stack trace. ");
        }
        if (this.loggingConfiguration.getLogLevel() != LogLevel.DEBUG) {
            details.resolution.text("Run with ");
            if (this.loggingConfiguration.getLogLevel() != LogLevel.INFO) {
                details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "info");
                details.resolution.text(" or ");
            }
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
            details.resolution.text(" option to get more log output.");
        }
    }

    private String getMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (GUtil.isTrue(message)) {
            return message;
        }
        return String.format("%s (no error message)", throwable.getClass().getName());
    }

    private void writeFailureDetails(StyledTextOutput output, FailureDetails details) {
        if (details.location.getHasContent()) {
            output.println();
            output.println("* Where:");
            details.location.writeTo(output);
            output.println();
        }
        if (details.details.getHasContent()) {
            output.println();
            output.println("* What went wrong:");
            details.details.writeTo(output);
            output.println();
        }
        if (details.resolution.getHasContent()) {
            output.println();
            output.println("* Try:");
            details.resolution.writeTo(output);
            output.println();
        }
        Throwable exception = null;
        switch (details.exceptionStyle) {
            case NONE: {
                break;
            }
            case FULL: {
                exception = details.failure;
            }
        }
        if (exception != null) {
            output.println();
            output.println("* Exception is:");
            output.exception(exception);
            output.println();
        }
    }

    private static class FailureDetails {
        Throwable failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        ExceptionStyle exceptionStyle = ExceptionStyle.NONE;

        public FailureDetails(Throwable failure) {
            this.failure = failure;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExceptionStyle {
        NONE,
        FULL;

    }
}

