/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.TaskDependency;

public class FileCollectionBackedTextResource
implements TextResource {
    private final TemporaryFileProvider tempFileProvider;
    private final FileCollection fileCollection;
    private final Charset charset;

    public FileCollectionBackedTextResource(TemporaryFileProvider tempFileProvider, FileCollection fileCollection, Charset charset) {
        this.tempFileProvider = tempFileProvider;
        this.fileCollection = fileCollection;
        this.charset = charset;
    }

    public String asString() {
        try {
            return Files.toString((File)this.asFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public Reader asReader() {
        try {
            return Files.newReader((File)this.asFile(), (Charset)this.charset);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public File asFile(String targetCharset) {
        Charset targetCharsetObj = Charset.forName(targetCharset);
        if (targetCharsetObj.equals(this.charset)) {
            return this.fileCollection.getSingleFile();
        }
        File targetFile = this.tempFileProvider.createTemporaryFile("fileCollection", ".txt", "resource");
        try {
            Files.asCharSource((File)this.fileCollection.getSingleFile(), (Charset)this.charset).copyTo(Files.asCharSink((File)targetFile, (Charset)targetCharsetObj, (FileWriteMode[])new FileWriteMode[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return targetFile;
    }

    public File asFile() {
        return this.asFile(Charset.defaultCharset().name());
    }

    public TaskDependency getBuildDependencies() {
        return this.fileCollection.getBuildDependencies();
    }

    public Object getInputProperties() {
        return this.charset.name();
    }

    public FileCollection getInputFiles() {
        return this.fileCollection;
    }
}

