/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.concurrent.Executor;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.execution.taskgraph.AbstractTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;

class ParallelTaskPlanExecutor
extends AbstractTaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(ParallelTaskPlanExecutor.class);
    private final int executorCount;
    private final ExecutorFactory executorFactory;

    public ParallelTaskPlanExecutor(int numberOfParallelExecutors, ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
        StoppableExecutor executor = this.executorFactory.create("Task worker");
        try {
            this.startAdditionalWorkers(taskExecutionPlan, taskListener, (Executor)executor);
            this.taskWorker(taskExecutionPlan, taskListener).run();
            taskExecutionPlan.awaitCompletion();
        }
        finally {
            executor.stop();
        }
    }

    private void startAdditionalWorkers(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener, Executor executor) {
        LOGGER.info("Using {} parallel executor threads", this.executorCount);
        for (int i = 1; i < this.executorCount; ++i) {
            Runnable worker = this.taskWorker(taskExecutionPlan, taskListener);
            executor.execute(worker);
        }
    }
}

