/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImperativeStatementDetectingTransformer
extends AbstractScriptTransformer
implements Factory<Boolean>,
GroovyCodeVisitor {
    private boolean imperativeStatementDetected;

    public void register(CompilationUnit compilationUnit) {
        super.register(compilationUnit);
    }

    protected int getPhase() {
        return 5;
    }

    public Boolean create() {
        return this.imperativeStatementDetected;
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        if (!source.getAST().getMethods().isEmpty()) {
            this.imperativeStatementDetected = true;
            return;
        }
        BlockStatement statementBlock = source.getAST().getStatementBlock();
        List statements = statementBlock.getStatements();
        if (statements.size() == 1 && AstUtils.isReturnNullStatement((Statement)((Statement)statements.get(0)))) {
            return;
        }
        for (int i = 0; i < statements.size() && !this.imperativeStatementDetected; ++i) {
            ((Statement)statements.get(i)).visit((GroovyCodeVisitor)this);
        }
    }

    public void visitBlockStatement(BlockStatement block) {
        for (Statement statement : block.getStatements()) {
            statement.visit((GroovyCodeVisitor)this);
        }
    }

    public void visitForLoop(ForStatement forLoop) {
        this.imperativeStatementDetected = true;
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.imperativeStatementDetected = true;
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.imperativeStatementDetected = true;
    }

    public void visitIfElse(IfStatement ifElse) {
        this.imperativeStatementDetected = true;
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        statement.getExpression().visit((GroovyCodeVisitor)this);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitTryCatchFinally(TryCatchStatement finally1) {
        this.imperativeStatementDetected = true;
    }

    public void visitSwitch(SwitchStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitCaseStatement(CaseStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.imperativeStatementDetected = true;
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        String methodName = AstUtils.extractConstantMethodName((MethodCallExpression)call);
        if (methodName == null) {
            this.imperativeStatementDetected = true;
            return;
        }
        ClosureExpression closureExpression = AstUtils.getSingleClosureArg((MethodCall)call);
        if (closureExpression == null || !methodName.equals("model")) {
            this.imperativeStatementDetected = true;
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitConstructorCallExpression(ConstructorCallExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitTupleExpression(TupleExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitMapExpression(MapExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitListExpression(ListExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitRangeExpression(RangeExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitAttributeExpression(AttributeExpression attributeExpression) {
        this.imperativeStatementDetected = true;
    }

    public void visitFieldExpression(FieldExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitConstantExpression(ConstantExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitClassExpression(ClassExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitVariableExpression(VariableExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitArrayExpression(ArrayExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitNotExpression(NotExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitCastExpression(CastExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitArgumentlistExpression(ArgumentListExpression expression) {
        this.imperativeStatementDetected = true;
    }

    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        this.imperativeStatementDetected = true;
    }

    public void visitBytecodeExpression(BytecodeExpression expression) {
        this.imperativeStatementDetected = true;
    }
}

