/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.collection.internal;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.Transformer;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.internal.BiAction;
import org.gradle.internal.Transformers;
import org.gradle.model.collection.internal.DynamicTypesDomainObjectContainerModelProjection;
import org.gradle.model.collection.internal.StaticTypeDomainObjectContainerModelProjection;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BridgedCollections {
    private static final Logger LOGGER = LoggerFactory.getLogger(BridgedCollections.class);

    private BridgedCollections() {
    }

    public static <I> ModelReference<NamedEntityInstantiator<I>> instantiatorReference(ModelPath containerPath, ModelType<I> itemType) {
        String instantiatorNodeName = "__instantiator";
        return ModelReference.of((ModelPath)containerPath.child("__instantiator"), (ModelType)new ModelType.Builder<NamedEntityInstantiator<I>>(){}.where(new ModelType.Parameter<I>(){}, itemType).build());
    }

    private static <I, C extends PolymorphicDomainObjectContainerInternal<I>> ContainerInfo<I> creator(final ModelRegistry modelRegistry, final ModelReference<C> containerReference, ModelType<I> itemType, final Transformer<? extends C, ? super MutableModelNode> containerFactory, final Namer<? super I> namer, String descriptor, final Transformer<String, String> itemDescriptorGenerator) {
        assert (containerReference.getPath() != null) : "container reference path cannot be null";
        String storeNodeName = "__store";
        final ModelReference<NamedEntityInstantiator<I>> instantiatorReference = BridgedCollections.instantiatorReference(containerReference.getPath(), itemType);
        final ModelReference storeReference = ModelReference.of((ModelPath)containerReference.getPath().child("__store"), (ModelType)containerReference.getType());
        ModelCreators.Builder creatorBuilder = ModelCreators.of(containerReference, (BiAction)new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(final MutableModelNode containerNode, List<ModelView<?>> inputs) {
                PolymorphicDomainObjectContainerInternal container = (PolymorphicDomainObjectContainerInternal)containerFactory.transform((Object)containerNode);
                ModelCreator storeCreator = ModelCreators.bridgedInstance((ModelReference)storeReference, (Object)container).ephemeral(true).hidden(true).descriptor((String)itemDescriptorGenerator.transform((Object)"__store")).build();
                modelRegistry.createOrReplace(storeCreator);
                String instantiatorNodeName = instantiatorReference.getPath().getName();
                ModelCreator instantiatorCreator = ModelCreators.bridgedInstance((ModelReference)instantiatorReference, container.getEntityInstantiator()).ephemeral(true).hidden(true).descriptor((String)itemDescriptorGenerator.transform((Object)instantiatorNodeName)).build();
                modelRegistry.createOrReplace(instantiatorCreator);
                containerNode.setPrivateData(containerReference.getType(), (Object)container);
                container.all(new Action<I>(){

                    public void execute(I item) {
                        final String name = namer.determineName(item);
                        if (!containerNode.isMutable()) {
                            LOGGER.debug("Ignoring element '{}' added to '{}' after it is closed.", (Object)containerReference.getPath(), (Object)name);
                            return;
                        }
                        if (!containerNode.hasLink(name)) {
                            ModelType itemType = ModelType.typeOf(item);
                            ModelReference itemReference = ModelReference.of((ModelPath)containerReference.getPath().child(name), (ModelType)itemType);
                            ModelCreator itemCreator = ModelCreators.of((ModelReference)itemReference, (BiAction)new BiAction<MutableModelNode, List<ModelView<?>>>(){

                                public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                                    PolymorphicDomainObjectContainerInternal container = (PolymorphicDomainObjectContainerInternal)ModelViews.assertType(modelViews.get(0), (ModelType)storeReference.getType()).getInstance();
                                    Object item = container.getByName(name);
                                    modelNode.setPrivateData(ModelType.typeOf(item), item);
                                }
                            }).inputs(new ModelReference[]{storeReference}).withProjection((ModelProjection)new UnmanagedModelProjection(itemType, true, true)).descriptor((String)itemDescriptorGenerator.transform((Object)name)).build();
                            containerNode.addLink(itemCreator);
                        }
                    }
                });
                container.whenObjectRemoved(new Action<I>(){

                    public void execute(I item) {
                        String name = namer.determineName(item);
                        containerNode.removeLink(name);
                    }
                });
            }
        }).ephemeral(true).descriptor(descriptor);
        return new ContainerInfo<I>(creatorBuilder, instantiatorReference, storeReference);
    }

    public static <I, C extends PolymorphicDomainObjectContainerInternal<I>, P> void dynamicTypes(ModelRegistry modelRegistry, ModelPath modelPath, String descriptor, ModelType<P> publicType, ModelType<C> containerType, ModelType<I> itemType, C container, Namer<? super I> namer, Transformer<String, String> itemDescriptorGenerator) {
        ModelReference containerReference = ModelReference.of((ModelPath)modelPath, containerType);
        ContainerInfo<? super I> containerInfo = BridgedCollections.creator(modelRegistry, containerReference, itemType, Transformers.constant(container), namer, descriptor, itemDescriptorGenerator);
        modelRegistry.createOrReplace(containerInfo.creatorBuilder.withProjection(new DynamicTypesDomainObjectContainerModelProjection<C, I>(container, itemType, containerInfo.instantiatorReference, containerInfo.storeReference)).withProjection((ModelProjection)new UnmanagedModelProjection(publicType, true, true)).build());
    }

    public static <I, C extends PolymorphicDomainObjectContainerInternal<I>, P> void staticTypes(ModelRegistry modelRegistry, ModelPath modelPath, ModelType<C> containerType, ModelType<I> itemType, ModelType<P> publicType, Transformer<? extends C, ? super MutableModelNode> containerFactory, Namer<? super I> namer, String descriptor, Transformer<String, String> itemDescriptorGenerator) {
        ModelReference containerReference = ModelReference.of((ModelPath)modelPath, containerType);
        ContainerInfo<? super I> containerInfo = BridgedCollections.creator(modelRegistry, containerReference, itemType, containerFactory, namer, descriptor, itemDescriptorGenerator);
        modelRegistry.createOrReplace(containerInfo.creatorBuilder.withProjection(new StaticTypeDomainObjectContainerModelProjection<C, I>(containerType, itemType, containerInfo.instantiatorReference, containerInfo.storeReference)).withProjection((ModelProjection)new UnmanagedModelProjection(publicType, true, true)).build());
    }

    public static Transformer<String, String> itemDescriptor(String parentDescriptor) {
        return new StandardItemDescriptorFactory(parentDescriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandardItemDescriptorFactory
    implements Transformer<String, String> {
        private final String descriptor;

        public StandardItemDescriptorFactory(String descriptor) {
            this.descriptor = descriptor;
        }

        public String transform(String s) {
            return this.descriptor + '.' + s + "()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerInfo<I> {
        final ModelCreators.Builder creatorBuilder;
        final ModelReference<NamedEntityInstantiator<I>> instantiatorReference;
        final ModelReference<? extends Collection<I>> storeReference;

        public ContainerInfo(ModelCreators.Builder creatorBuilder, ModelReference<NamedEntityInstantiator<I>> instantiatorReference, ModelReference<? extends Collection<I>> storeReference) {
            this.creatorBuilder = creatorBuilder;
            this.instantiatorReference = instantiatorReference;
            this.storeReference = storeReference;
        }
    }
}

