/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.persist;

import com.google.common.collect.Maps;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.persist.ModelRegistryStore;
import org.gradle.model.internal.registry.DefaultModelRegistry;
import org.gradle.model.internal.registry.ModelRegistry;

@NotThreadSafe
public class ReusingModelRegistryStore
implements ModelRegistryStore {
    private static final Logger LOGGER = Logging.getLogger(ReusingModelRegistryStore.class);
    public static final String TOGGLE = "org.gradle.model.reuse";
    public static final String BANNER = "Experimental model reuse is enabled.";
    private final ModelRuleExtractor ruleExtractor;
    private final Map<String, ModelRegistry> store = Maps.newHashMap();

    public ReusingModelRegistryStore(ModelRuleExtractor ruleExtractor) {
        this.ruleExtractor = ruleExtractor;
    }

    public ModelRegistry get(ProjectIdentifier projectIdentifier) {
        ModelRegistry modelRegistry = this.store.get(projectIdentifier.getProjectDir().getAbsolutePath());
        if (modelRegistry == null) {
            LOGGER.info("creating new model registry for project: " + projectIdentifier.getPath());
            modelRegistry = new DefaultModelRegistry(this.ruleExtractor);
            this.store.put(projectIdentifier.getProjectDir().getAbsolutePath(), modelRegistry);
        } else {
            LOGGER.info("reusing model for project: " + projectIdentifier.getPath());
            modelRegistry.prepareForReuse();
        }
        return modelRegistry;
    }
}

