/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.ExecHandleRunner;
import org.gradle.process.internal.ExecHandleShutdownHookAction;
import org.gradle.process.internal.ExecHandleState;
import org.gradle.process.internal.ProcessSettings;
import org.gradle.process.internal.shutdown.ShutdownHookActionRegister;
import org.gradle.process.internal.streams.StreamsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecHandle
implements ExecHandle,
ProcessSettings {
    private static final Logger LOGGER = Logging.getLogger(DefaultExecHandle.class);
    private final String displayName;
    private final File directory;
    private final String command;
    private final List<String> arguments;
    private final Map<String, String> environment;
    private final StreamsHandler streamsHandler;
    private final boolean redirectErrorStream;
    private final ProcessLauncher processLauncher;
    private int timeoutMillis;
    private boolean daemon;
    private final Lock lock;
    private final Condition condition;
    private final StoppableExecutor executor;
    private ExecHandleState state;
    private ExecHandleRunner execHandleRunner;
    private ExecResultImpl execResult;
    private final ListenerBroadcast<ExecHandleListener> broadcast;
    private final ExecHandleShutdownHookAction shutdownHookAction;

    DefaultExecHandle(String displayName, File directory, String command, List<String> arguments, Map<String, String> environment, StreamsHandler streamsHandler, List<ExecHandleListener> listeners, boolean redirectErrorStream, int timeoutMillis, boolean daemon) {
        this.displayName = displayName;
        this.directory = directory;
        this.command = command;
        this.arguments = arguments;
        this.environment = environment;
        this.streamsHandler = streamsHandler;
        this.redirectErrorStream = redirectErrorStream;
        this.timeoutMillis = timeoutMillis;
        this.daemon = daemon;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.state = ExecHandleState.INIT;
        this.executor = new DefaultExecutorFactory().create(String.format("Run %s", displayName));
        this.processLauncher = (ProcessLauncher)NativeServices.getInstance().get(ProcessLauncher.class);
        this.shutdownHookAction = new ExecHandleShutdownHookAction(this);
        this.broadcast = new ListenerBroadcast(ExecHandleListener.class);
        this.broadcast.addAll(listeners);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecHandleState getState() {
        this.lock.lock();
        try {
            ExecHandleState execHandleState = this.state;
            return execHandleState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ExecHandleState state) {
        this.lock.lock();
        try {
            LOGGER.debug("Changing state to: {}", (Object)state);
            this.state = state;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stateIn(ExecHandleState ... states) {
        this.lock.lock();
        try {
            boolean bl = Arrays.asList(states).contains((Object)this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEndStateInfo(ExecHandleState newState, int exitValue, Throwable failureCause) {
        ExecResultImpl result;
        ExecHandleState currentState;
        ShutdownHookActionRegister.removeAction(this.shutdownHookAction);
        this.lock.lock();
        try {
            currentState = this.state;
            ExecException wrappedException = null;
            if (failureCause != null) {
                wrappedException = currentState == ExecHandleState.STARTING ? new ExecException(String.format("A problem occurred starting process '%s'", this.displayName), failureCause) : new ExecException(String.format("A problem occurred waiting for process '%s' to complete.", this.displayName), failureCause);
            }
            this.setState(newState);
            result = this.execResult = new ExecResultImpl(exitValue, wrappedException, this.displayName);
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.debug("Process '{}' finished with exit value {} (state: {})", new Object[]{this.displayName, exitValue, newState});
        if (currentState != ExecHandleState.DETACHED && newState != ExecHandleState.DETACHED) {
            ((ExecHandleListener)this.broadcast.getSource()).executionFinished(this, result);
        }
        this.executor.requestStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecHandle start() {
        LOGGER.info("Starting process '{}'. Working directory: {} Command: {}", this.displayName, this.directory, this.command + ' ' + Joiner.on((char)' ').useForNull("null").join(this.arguments));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Environment for process '{}': {}", this.displayName, this.environment);
        }
        this.lock.lock();
        try {
            if (!this.stateIn(ExecHandleState.INIT)) {
                throw new IllegalStateException(String.format("Cannot start process '%s' because it has already been started", this.displayName));
            }
            this.setState(ExecHandleState.STARTING);
            this.execHandleRunner = new ExecHandleRunner(this, this.streamsHandler, this.processLauncher);
            this.executor.execute((Runnable)this.execHandleRunner);
            while (this.stateIn(ExecHandleState.STARTING)) {
                LOGGER.debug("Waiting until process started: {}.", this.displayName);
                try {
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.execResult != null) {
                this.execResult.rethrowFailure();
            }
            LOGGER.info("Successfully started process '{}'", this.displayName);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.lock.lock();
        try {
            if (this.state == ExecHandleState.SUCCEEDED) {
                return;
            }
            if (!this.stateIn(ExecHandleState.STARTED, ExecHandleState.DETACHED)) {
                throw new IllegalStateException(String.format("Cannot abort process '%s' because it is not in started or detached state", this.displayName));
            }
            this.execHandleRunner.abortProcess();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResult waitForFinish() {
        this.lock.lock();
        try {
            while (!this.stateIn(ExecHandleState.SUCCEEDED, ExecHandleState.ABORTED, ExecHandleState.FAILED, ExecHandleState.DETACHED)) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
        this.executor.stop();
        return this.result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecResult result() {
        this.lock.lock();
        try {
            this.execResult.rethrowFailure();
            ExecResultImpl execResultImpl = this.execResult;
            return execResultImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void detached() {
        this.setEndStateInfo(ExecHandleState.DETACHED, 0, null);
    }

    void started() {
        ShutdownHookActionRegister.addAction(this.shutdownHookAction);
        this.setState(ExecHandleState.STARTED);
        ((ExecHandleListener)this.broadcast.getSource()).executionStarted(this);
    }

    void finished(int exitCode) {
        if (exitCode != 0) {
            this.setEndStateInfo(ExecHandleState.FAILED, exitCode, null);
        } else {
            this.setEndStateInfo(ExecHandleState.SUCCEEDED, 0, null);
        }
    }

    void aborted(int exitCode) {
        if (exitCode == 0) {
            exitCode = -1;
        }
        this.setEndStateInfo(ExecHandleState.ABORTED, exitCode, null);
    }

    void failed(Throwable failureCause) {
        this.setEndStateInfo(ExecHandleState.FAILED, -1, failureCause);
    }

    @Override
    public void addListener(ExecHandleListener listener) {
        this.broadcast.add((Object)listener);
    }

    @Override
    public void removeListener(ExecHandleListener listener) {
        this.broadcast.remove((Object)listener);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean getRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    private static class ExecResultImpl
    implements ExecResult {
        private final int exitValue;
        private final ExecException failure;
        private final String displayName;

        public ExecResultImpl(int exitValue, ExecException failure, String displayName) {
            this.exitValue = exitValue;
            this.failure = failure;
            this.displayName = displayName;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public ExecResult assertNormalExitValue() throws ExecException {
            if (this.exitValue != 0) {
                throw new ExecException(String.format("Process '%s' finished with non-zero exit value %d", this.displayName, this.exitValue));
            }
            return this;
        }

        public ExecResult rethrowFailure() throws ExecException {
            if (this.failure != null) {
                throw this.failure;
            }
            return this;
        }

        public String toString() {
            return "{exitValue=" + this.exitValue + ", failure=" + (Object)((Object)this.failure) + "}";
        }
    }
}

