/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenArtifact
implements Serializable,
MavenCoordinate {
    static long serialVersionUID = 6389627095309274357L;
    public static final String MAVEN_LIB_PREFIX = "Maven: ";
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myBaseVersion;
    private final String myType;
    private final String myClassifier;
    private String myScope;
    private final boolean myOptional;
    private final String myExtension;
    private final File myFile;
    private final boolean myResolved;
    private final boolean myStubbed;
    private volatile transient String myLibraryNameCache;
    private volatile transient long myLastFileCheckTimeStamp;

    public MavenArtifact(String groupId, String artifactId, String version, String baseVersion, String type, String classifier, String scope, boolean optional, String extension, File file, File localRepository, boolean resolved, boolean stubbed) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myBaseVersion = baseVersion;
        this.myType = type;
        this.myClassifier = classifier;
        this.myScope = scope;
        this.myOptional = optional;
        this.myExtension = extension;
        this.myFile = file != null ? file : new File(localRepository, this.getRelativePath());
        this.myResolved = resolved;
        this.myStubbed = stubbed;
    }

    @Override
    public String getGroupId() {
        return this.myGroupId;
    }

    @Override
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    public String getBaseVersion() {
        return this.myBaseVersion;
    }

    public MavenId getMavenId() {
        return new MavenId(this.myGroupId, this.myArtifactId, this.myVersion);
    }

    public String getType() {
        return this.myType;
    }

    public String getClassifier() {
        return this.myClassifier;
    }

    public String getScope() {
        return this.myScope;
    }

    public void setScope(String scope) {
        this.myScope = scope;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    public boolean isExportable() {
        if (this.myOptional) {
            return false;
        }
        return "compile".equals(this.myScope) || "runtime".equals(this.myScope);
    }

    public String getExtension() {
        return this.myExtension;
    }

    public boolean isResolved() {
        if (this.myResolved && !this.myStubbed) {
            long currentTime = System.currentTimeMillis();
            if (this.myLastFileCheckTimeStamp + 2000L < currentTime) {
                if (!this.myFile.exists()) {
                    return false;
                }
                this.myLastFileCheckTimeStamp = currentTime;
            }
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.myFile;
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)this.myFile.getPath());
    }

    public String getRelativePath() {
        return this.getRelativePathForExtraArtifact(null, null);
    }

    public String getFileNameWithBaseVersion(String extraArtifactClassifier, String customExtension) {
        StringBuilder res = new StringBuilder();
        this.appendFileName(res, extraArtifactClassifier, customExtension);
        return res.toString();
    }

    private void appendFileName(StringBuilder result, String extraArtifactClassifier, String customExtension) {
        result.append(this.myArtifactId);
        result.append('-');
        result.append(this.myVersion);
        String fullClassifier = this.getFullClassifier(extraArtifactClassifier);
        if (fullClassifier != null) {
            result.append("-").append(fullClassifier);
        }
        result.append(".");
        result.append(customExtension == null ? this.myExtension : customExtension);
    }

    public String getRelativePathForExtraArtifact(String extraArtifactClassifier, String customExtension) {
        StringBuilder result = new StringBuilder();
        result.append(this.myGroupId.replace('.', '/'));
        result.append('/');
        result.append(this.myArtifactId);
        result.append('/');
        result.append(this.myBaseVersion);
        result.append('/');
        this.appendFileName(result, extraArtifactClassifier, customExtension);
        return result.toString();
    }

    public String getFullClassifier(String extraClassifier) {
        if (StringUtil.isEmptyOrSpaces((String)extraClassifier)) {
            return this.myClassifier;
        }
        String result = "";
        if ("test-jar".equals(this.myType) || "tests".equals(this.myClassifier)) {
            result = result + "test";
        }
        if (!StringUtil.isEmptyOrSpaces((String)extraClassifier)) {
            result = result + (!result.isEmpty() ? "-" + extraClassifier : extraClassifier);
        }
        return StringUtil.isEmptyOrSpaces((String)result) ? null : result;
    }

    public String getPathForExtraArtifact(String extraArtifactClassifier, String customExtension) {
        String path = this.getPath();
        if (extraArtifactClassifier == null && customExtension == null && Comparing.equal((String)this.myVersion, (String)this.myBaseVersion)) {
            return path;
        }
        int slashPos = path.lastIndexOf(47);
        if (slashPos != -1) {
            StringBuilder res = new StringBuilder();
            res.append(path, 0, slashPos + 1);
            res.append(this.myArtifactId);
            res.append('-');
            res.append(this.myVersion);
            String fullClassifier = this.getFullClassifier(extraArtifactClassifier);
            if (fullClassifier != null) {
                res.append('-').append(fullClassifier);
            }
            res.append('.');
            res.append(customExtension == null ? this.myExtension : customExtension);
            return res.toString();
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos != -1) {
            StringBuilder res = new StringBuilder();
            res.append(path, 0, dotPos);
            res.append('-');
            res.append(extraArtifactClassifier);
            res.append(customExtension == null ? this.myExtension : customExtension);
            return res.toString();
        }
        return path;
    }

    public String getDisplayStringSimple() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringWithType() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myType);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringWithTypeAndClassifier() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myType);
        if (!StringUtil.isEmptyOrSpaces((String)this.myClassifier)) {
            MavenId.append(builder, this.myClassifier);
        }
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringFull() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myType);
        if (!StringUtil.isEmptyOrSpaces((String)this.myClassifier)) {
            MavenId.append(builder, this.myClassifier);
        }
        MavenId.append(builder, this.myVersion);
        if (!StringUtil.isEmptyOrSpaces((String)this.myScope)) {
            MavenId.append(builder, this.myScope);
        }
        return builder.toString();
    }

    public String getLibraryName() {
        String res = this.myLibraryNameCache;
        if (res == null) {
            String version;
            StringBuilder builder = new StringBuilder();
            MavenId.append(builder, this.myGroupId);
            MavenId.append(builder, this.myArtifactId);
            if (!StringUtil.isEmptyOrSpaces((String)this.myType) && !"jar".equals(this.myType)) {
                MavenId.append(builder, this.myType);
            }
            if (!StringUtil.isEmptyOrSpaces((String)this.myClassifier)) {
                MavenId.append(builder, this.myClassifier);
            }
            String string = version = !StringUtil.isEmptyOrSpaces((String)this.myBaseVersion) ? this.myBaseVersion : this.myVersion;
            if (!StringUtil.isEmptyOrSpaces((String)version)) {
                MavenId.append(builder, version);
            }
            builder.insert(0, MAVEN_LIB_PREFIX);
            this.myLibraryNameCache = res = builder.toString();
        }
        return res;
    }

    public String getDisplayStringForLibraryName() {
        return this.getLibraryName().substring(MAVEN_LIB_PREFIX.length());
    }

    public static boolean isMavenLibrary(String libraryName) {
        return libraryName != null && libraryName.startsWith(MAVEN_LIB_PREFIX);
    }

    public String toString() {
        return this.getDisplayStringFull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifact that = (MavenArtifact)o;
        if (this.myGroupId != null ? !this.myGroupId.equals(that.myGroupId) : that.myGroupId != null) {
            return false;
        }
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        if (this.myBaseVersion != null ? !this.myBaseVersion.equals(that.myBaseVersion) : that.myBaseVersion != null) {
            return false;
        }
        if (this.myType != null ? !this.myType.equals(that.myType) : that.myType != null) {
            return false;
        }
        if (this.myClassifier != null ? !this.myClassifier.equals(that.myClassifier) : that.myClassifier != null) {
            return false;
        }
        if (this.myScope != null ? !this.myScope.equals(that.myScope) : that.myScope != null) {
            return false;
        }
        if (this.myExtension != null ? !this.myExtension.equals(that.myExtension) : that.myExtension != null) {
            return false;
        }
        return !(this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null);
    }

    public int hashCode() {
        int result = this.myGroupId != null ? this.myGroupId.hashCode() : 0;
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myBaseVersion != null ? this.myBaseVersion.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        result = 31 * result + (this.myClassifier != null ? this.myClassifier.hashCode() : 0);
        result = 31 * result + (this.myScope != null ? this.myScope.hashCode() : 0);
        result = 31 * result + (this.myExtension != null ? this.myExtension.hashCode() : 0);
        result = 31 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        return result;
    }
}

