/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import org.jetbrains.idea.maven.model.MavenCoordinate;

public class MavenId
implements Serializable,
MavenCoordinate {
    public static final String UNKNOWN_VALUE = "Unknown";
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;

    public MavenId(String groupId, String artifactId, String version) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
    }

    @Override
    public String getGroupId() {
        return this.myGroupId;
    }

    @Override
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    public String getKey() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String getDisplayString() {
        return this.getKey();
    }

    public static void append(StringBuilder builder, String part) {
        if (builder.length() != 0) {
            builder.append(':');
        }
        builder.append(part == null ? "<unknown>" : part);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals(String groupId, String artifactId) {
        if (this.myArtifactId != null ? !this.myArtifactId.equals(artifactId) : artifactId != null) {
            return false;
        }
        return !(this.myGroupId != null ? !this.myGroupId.equals(groupId) : groupId != null);
    }

    public boolean equals(String groupId, String artifactId, String version) {
        if (!this.equals(groupId, artifactId)) {
            return false;
        }
        return !(this.myVersion != null ? !this.myVersion.equals(version) : version != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenId other = (MavenId)o;
        return this.equals(other.getGroupId(), other.myArtifactId, other.myVersion);
    }

    public int hashCode() {
        int result = this.myGroupId != null ? this.myGroupId.hashCode() : 0;
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        return result;
    }
}

