/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.JDOMUtil;
import java.io.Serializable;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenPlugin
implements Serializable {
    static final long serialVersionUID = -6113607480882347420L;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final boolean myDefault;
    private final Element myConfiguration;
    private final List<Execution> myExecutions;
    private final List<MavenId> myDependencies;

    public MavenPlugin(String groupId, String artifactId, String version, boolean aDefault, Element configuration, List<Execution> executions, List<MavenId> dependencies) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myDefault = aDefault;
        this.myConfiguration = configuration;
        this.myExecutions = executions;
        this.myDependencies = dependencies;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public MavenId getMavenId() {
        return new MavenId(this.myGroupId, this.myArtifactId, this.myVersion);
    }

    public boolean isDefault() {
        return this.myDefault;
    }

    public Element getConfigurationElement() {
        return this.myConfiguration;
    }

    public List<Execution> getExecutions() {
        return this.myExecutions;
    }

    public List<MavenId> getDependencies() {
        return this.myDependencies;
    }

    public Element getGoalConfiguration(String goal) {
        for (Execution each : this.getExecutions()) {
            if (!each.getGoals().contains(goal)) continue;
            return each.getConfigurationElement();
        }
        return null;
    }

    public Element getExecutionConfiguration(String executionId) {
        for (Execution each : this.getExecutions()) {
            if (!executionId.equals(each.getExecutionId())) continue;
            return each.getConfigurationElement();
        }
        return null;
    }

    public String getDisplayString() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenPlugin that = (MavenPlugin)o;
        if (this.myDefault != that.myDefault) {
            return false;
        }
        if (this.myGroupId != null ? !this.myGroupId.equals(that.myGroupId) : that.myGroupId != null) {
            return false;
        }
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        if (!JDOMUtil.areElementsEqual((Element)this.myConfiguration, (Element)that.myConfiguration)) {
            return false;
        }
        if (this.myExecutions != null ? !((Object)this.myExecutions).equals(that.myExecutions) : that.myExecutions != null) {
            return false;
        }
        return !(this.myDependencies != null ? !((Object)this.myDependencies).equals(that.myDependencies) : that.myDependencies != null);
    }

    public int hashCode() {
        int result = this.myDefault ? 1 : 0;
        result = 31 * result + (this.myGroupId != null ? this.myGroupId.hashCode() : 0);
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myConfiguration != null ? JDOMUtil.getTreeHash((Element)this.myConfiguration) : 0);
        result = 31 * result + (this.myExecutions != null ? ((Object)this.myExecutions).hashCode() : 0);
        result = 31 * result + (this.myDependencies != null ? ((Object)this.myDependencies).hashCode() : 0);
        return result;
    }

    public static class Execution
    implements Serializable {
        private final List<String> myGoals;
        private final Element myConfiguration;
        private final String myExecutionId;

        public Execution(String executionId, List<String> goals, Element configuration) {
            this.myGoals = goals;
            this.myConfiguration = configuration;
            this.myExecutionId = executionId;
        }

        public String getExecutionId() {
            return this.myExecutionId;
        }

        public List<String> getGoals() {
            return this.myGoals;
        }

        public Element getConfigurationElement() {
            return this.myConfiguration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Execution that = (Execution)o;
            if (this.myGoals != null ? !((Object)this.myGoals).equals(that.myGoals) : that.myGoals != null) {
                return false;
            }
            if (this.myExecutionId != null ? !this.myExecutionId.equals(that.myExecutionId) : that.myExecutionId != null) {
                return false;
            }
            return JDOMUtil.areElementsEqual((Element)this.myConfiguration, (Element)that.myConfiguration);
        }

        public int hashCode() {
            int result;
            int n = result = this.myGoals != null ? ((Object)this.myGoals).hashCode() : 0;
            if (this.myExecutionId != null) {
                result = 31 * result + this.myExecutionId.hashCode();
            }
            return result;
        }
    }
}

