/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.gradle.api.GradleException;
import org.gradle.api.publication.maven.internal.action.LoggingMavenTransferListener;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publication.maven.internal.action.ParsedMavenPom;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMavenPublishAction
implements MavenPublishAction {
    private static ClassLoader plexusClassLoader;
    protected final WagonManager wagonManager;
    private final File pomFile;
    private final List<AdditionalArtifact> additionalArtifacts = Lists.newArrayList();
    private File mainArtifact;
    private File localMavenRepository;
    private PlexusContainer container;

    protected AbstractMavenPublishAction(File pomFile) {
        this.pomFile = pomFile;
        this.wagonManager = this.lookup(WagonManager.class);
        this.wagonManager.setDownloadMonitor((TransferListener)new LoggingMavenTransferListener());
    }

    public void setLocalMavenRepositoryLocation(File localMavenRepository) {
        this.localMavenRepository = localMavenRepository;
    }

    @Override
    public void setMainArtifact(File file) {
        this.mainArtifact = file;
    }

    @Override
    public void addAdditionalArtifact(File file, String type, String classifier) {
        AdditionalArtifact artifact = new AdditionalArtifact();
        artifact.setFile(file);
        artifact.setType(type);
        artifact.setClassifier(classifier);
        this.additionalArtifacts.add(artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (plexusClassLoader != null) {
                Thread.currentThread().setContextClassLoader(plexusClassLoader);
            }
            this.doPublish();
        }
        finally {
            plexusClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void doPublish() {
        Artifact parentArtifact;
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        ParsedMavenPom parsedMavenPom = new ParsedMavenPom(this.pomFile);
        if (this.mainArtifact == null) {
            Artifact pomArtifact = this.createPomArtifact(parsedMavenPom);
            this.publishArtifact(pomArtifact, this.pomFile, localRepo);
            parentArtifact = pomArtifact;
        } else {
            Artifact artifact = this.createMainArtifact(parsedMavenPom);
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
            this.publishArtifact(artifact, this.mainArtifact, localRepo);
            parentArtifact = artifact;
        }
        for (AdditionalArtifact attachedArtifact : this.additionalArtifacts) {
            Artifact attach = this.createAttachedArtifact(parentArtifact, attachedArtifact.getType(), attachedArtifact.getClassifier());
            this.publishArtifact(attach, attachedArtifact.getFile(), localRepo);
        }
    }

    protected abstract void publishArtifact(Artifact var1, File var2, ArtifactRepository var3);

    private ArtifactRepository createLocalArtifactRepository() {
        String localRepositoryLocation = this.localMavenRepository.toURI().toString();
        return new DefaultArtifactRepository("local", localRepositoryLocation, (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
    }

    protected <T> T lookup(Class<T> type) {
        String role = type.getName();
        try {
            Object lookup1 = this.getContainer().lookup(role);
            return (T)lookup1;
        }
        catch (ComponentLookupException e) {
            throw new GradleException("Unable to find component: " + role, (Throwable)e);
        }
    }

    protected synchronized PlexusContainer getContainer() {
        if (this.container == null) {
            try {
                ClassWorld classWorld = new ClassWorld();
                classWorld.newRealm("plexus.core", this.getClass().getClassLoader());
                Embedder embedder = new Embedder();
                embedder.start(classWorld);
                this.container = embedder.getContainer();
            }
            catch (PlexusContainerException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            catch (DuplicateRealmException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return this.container;
    }

    private Artifact createMainArtifact(ParsedMavenPom pom) {
        return new DefaultArtifact(pom.getGroup(), pom.getArtifactId(), VersionRange.createFromVersion((String)pom.getVersion()), null, pom.getPackaging(), null, (ArtifactHandler)this.artifactHandler(pom.getPackaging()));
    }

    private Artifact createPomArtifact(ParsedMavenPom pom) {
        return new DefaultArtifact(pom.getGroup(), pom.getArtifactId(), VersionRange.createFromVersion((String)pom.getVersion()), null, "pom", null, (ArtifactHandler)this.artifactHandler("pom"));
    }

    private Artifact createAttachedArtifact(Artifact mainArtifact, String type, String classifier) {
        return new AttachedArtifact(mainArtifact, type, classifier, (ArtifactHandler)this.artifactHandler(type));
    }

    private DefaultArtifactHandler artifactHandler(String type) {
        return new DefaultArtifactHandler(type);
    }

    private static class AdditionalArtifact {
        File file;
        String type;
        String classifier;

        private AdditionalArtifact() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String getClassifier() {
            return this.classifier;
        }
    }
}

