/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingMavenTransferListener
implements TransferListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingMavenTransferListener.class);
    private static final int KILO = 1024;

    LoggingMavenTransferListener() {
    }

    protected void log(String message) {
        LOGGER.info(message);
    }

    public void debug(String s) {
        LOGGER.debug(s);
    }

    public void transferError(TransferEvent event) {
        LOGGER.error(event.getException().getMessage());
    }

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == 6 ? "Uploading" : "Downloading";
        String dest = event.getRequestType() == 6 ? " to " : " from ";
        LOGGER.info(message + ": " + event.getResource().getName() + dest + "repository " + event.getWagon().getRepository().getId() + " at " + event.getWagon().getRepository().getUrl());
    }

    public void transferStarted(TransferEvent event) {
        long contentLength = event.getResource().getContentLength();
        if (contentLength > 0L) {
            LOGGER.info("Transferring " + (contentLength + 512L) / 1024L + "K from " + event.getWagon().getRepository().getId());
        }
    }

    public void transferProgress(TransferEvent event, byte[] bytes, int i) {
    }

    public void transferCompleted(TransferEvent event) {
        long contentLength = event.getResource().getContentLength();
        if (contentLength > 0L && event.getRequestType() == 6) {
            LOGGER.info("Uploaded " + (contentLength + 512L) / 1024L + "K");
        }
    }
}

