/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.Authentication;
import org.apache.maven.artifact.ant.Proxy;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.gradle.api.GradleException;
import org.gradle.api.publication.maven.internal.action.AbstractMavenPublishAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDeployAction
extends AbstractMavenPublishAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenDeployAction.class);
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;
    private boolean uniqueVersion = true;

    public MavenDeployAction(File pomFile) {
        super(pomFile);
    }

    public void setRepositories(RemoteRepository repository, RemoteRepository snapshotRepository) {
        this.remoteRepository = repository;
        this.remoteSnapshotRepository = snapshotRepository;
    }

    public void setUniqueVersion(boolean uniqueVersion) {
        this.uniqueVersion = uniqueVersion;
    }

    protected void publishArtifact(Artifact artifact, File artifactFile, ArtifactRepository localRepo) {
        ArtifactDeployer deployer = this.lookup(ArtifactDeployer.class);
        ArtifactRepository deploymentRepository = this.getRemoteArtifactRepository(artifact);
        LOGGER.info("Deploying to " + deploymentRepository.getUrl());
        try {
            deployer.deploy(artifactFile, artifact, deploymentRepository, localRepo);
        }
        catch (ArtifactDeploymentException e) {
            throw new GradleException("Error deploying artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private ArtifactRepository getRemoteArtifactRepository(Artifact artifact) {
        RemoteRepository deploymentRepository = this.remoteRepository;
        if (artifact.isSnapshot() && this.remoteSnapshotRepository != null) {
            deploymentRepository = this.remoteSnapshotRepository;
        }
        if (deploymentRepository == null) {
            throw new GradleException("Must specify a repository for deployment");
        }
        this.initWagonManagerWithRepositorySettings("remote", deploymentRepository);
        return new DefaultArtifactRepository("remote", deploymentRepository.getUrl(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), this.uniqueVersion);
    }

    private void initWagonManagerWithRepositorySettings(String repositoryId, RemoteRepository repository) {
        Proxy proxy;
        Authentication authentication = repository.getAuthentication();
        if (authentication != null) {
            this.wagonManager.addAuthenticationInfo(repositoryId, authentication.getUserName(), authentication.getPassword(), authentication.getPrivateKey(), authentication.getPassphrase());
        }
        if ((proxy = repository.getProxy()) != null) {
            this.wagonManager.addProxy(proxy.getType(), proxy.getHost(), proxy.getPort(), proxy.getUserName(), proxy.getPassword(), proxy.getNonProxyHosts());
        }
    }
}

