/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.GradleException;

class ParsedMavenPom {
    private final Model model;

    public ParsedMavenPom(File pomFile) {
        try {
            this.model = this.parsePom(pomFile);
        }
        catch (Exception e) {
            throw new GradleException("Cannot read generated POM!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model parsePom(File pomFile) throws IOException, XmlPullParserException {
        FileReader reader = new FileReader(pomFile);
        try {
            Model model = new MavenXpp3Reader().read((Reader)reader, false);
            return model;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public String getGroup() {
        return this.model.getGroupId();
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    public String getVersion() {
        return this.model.getVersion();
    }

    public String getPackaging() {
        return this.model.getPackaging();
    }
}

