/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.pom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.maven.Conf2ScopeMapping;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.publication.maven.internal.VersionRangeMapper;
import org.gradle.api.publication.maven.internal.pom.ExcludeRuleConverter;
import org.gradle.api.publication.maven.internal.pom.PomDependenciesConverter;
import org.gradle.api.publication.maven.internal.pom.ProjectDependencyArtifactIdExtractorHack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultPomDependenciesConverter
implements PomDependenciesConverter {
    private ExcludeRuleConverter excludeRuleConverter;
    private VersionRangeMapper versionRangeMapper;

    public DefaultPomDependenciesConverter(ExcludeRuleConverter excludeRuleConverter, VersionRangeMapper versionRangeMapper) {
        this.excludeRuleConverter = excludeRuleConverter;
        this.versionRangeMapper = versionRangeMapper;
    }

    public List<Dependency> convert(Conf2ScopeMappingContainer conf2ScopeMappingContainer, Set<Configuration> configurations) {
        Map<ModuleDependency, Set<Configuration>> dependencyToConfigurations = this.createDependencyToConfigurationsMap(configurations);
        Map<ModuleDependency, String> dependenciesMap = this.createDependencyToScopeMap(conf2ScopeMappingContainer, dependencyToConfigurations);
        ArrayList<Dependency> mavenDependencies = new ArrayList<Dependency>();
        for (ModuleDependency dependency : dependenciesMap.keySet()) {
            String scope = dependenciesMap.get(dependency);
            Set<Configuration> dependencyConfigurations = dependencyToConfigurations.get(dependency);
            if (dependency.getArtifacts().size() == 0) {
                this.addFromDependencyDescriptor(mavenDependencies, dependency, scope, dependencyConfigurations);
                continue;
            }
            this.addFromArtifactDescriptor(mavenDependencies, dependency, scope, dependencyConfigurations);
        }
        return mavenDependencies;
    }

    private Map<ModuleDependency, String> createDependencyToScopeMap(Conf2ScopeMappingContainer conf2ScopeMappingContainer, Map<ModuleDependency, Set<Configuration>> dependencyToConfigurations) {
        HashMap<ModuleDependency, String> dependencyToScope = new HashMap<ModuleDependency, String>();
        for (ModuleDependency dependency : dependencyToConfigurations.keySet()) {
            Conf2ScopeMapping conf2ScopeDependencyMapping = conf2ScopeMappingContainer.getMapping((Collection<Configuration>)dependencyToConfigurations.get(dependency));
            if (!this.useScope(conf2ScopeMappingContainer, conf2ScopeDependencyMapping)) continue;
            dependencyToScope.put(this.findDependency(dependency, conf2ScopeDependencyMapping.getConfiguration()), conf2ScopeDependencyMapping.getScope());
        }
        return dependencyToScope;
    }

    private ModuleDependency findDependency(ModuleDependency dependency, Configuration configuration) {
        for (ModuleDependency configurationDependency : configuration.getDependencies().withType(ModuleDependency.class)) {
            if (!dependency.equals(configurationDependency)) continue;
            return configurationDependency;
        }
        throw new GradleException("Dependency could not be found. We should never get here!");
    }

    private boolean useScope(Conf2ScopeMappingContainer conf2ScopeMappingContainer, Conf2ScopeMapping conf2ScopeMapping) {
        return conf2ScopeMapping.getScope() != null || !conf2ScopeMappingContainer.isSkipUnmappedConfs();
    }

    private Map<ModuleDependency, Set<Configuration>> createDependencyToConfigurationsMap(Set<Configuration> configurations) {
        HashMap<ModuleDependency, Set<Configuration>> dependencySetMap = new HashMap<ModuleDependency, Set<Configuration>>();
        for (Configuration configuration : configurations) {
            for (ModuleDependency dependency : configuration.getDependencies().withType(ModuleDependency.class)) {
                if (dependencySetMap.get(dependency) == null) {
                    dependencySetMap.put(dependency, new HashSet());
                }
                ((Set)dependencySetMap.get(dependency)).add(configuration);
            }
        }
        return dependencySetMap;
    }

    private void addFromArtifactDescriptor(List<Dependency> mavenDependencies, ModuleDependency dependency, String scope, Set<Configuration> configurations) {
        for (DependencyArtifact artifact : dependency.getArtifacts()) {
            mavenDependencies.add(this.createMavenDependencyFromArtifactDescriptor(dependency, artifact, scope, configurations));
        }
    }

    private void addFromDependencyDescriptor(List<Dependency> mavenDependencies, ModuleDependency dependency, String scope, Set<Configuration> configurations) {
        mavenDependencies.add(this.createMavenDependencyFromDependencyDescriptor(dependency, scope, configurations));
    }

    private Dependency createMavenDependencyFromArtifactDescriptor(ModuleDependency dependency, DependencyArtifact artifact, String scope, Set<Configuration> configurations) {
        return this.createMavenDependency(dependency, artifact.getName(), artifact.getType(), scope, artifact.getClassifier(), configurations);
    }

    private Dependency createMavenDependencyFromDependencyDescriptor(ModuleDependency dependency, String scope, Set<Configuration> configurations) {
        return this.createMavenDependency(dependency, dependency.getName(), null, scope, null, configurations);
    }

    private Dependency createMavenDependency(ModuleDependency dependency, String name, String type, String scope, String classifier, Set<Configuration> configurations) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(dependency.getGroup());
        if (dependency instanceof ProjectDependency) {
            mavenDependency.setArtifactId(this.determineProjectDependencyArtifactId((ProjectDependency)dependency));
        } else {
            mavenDependency.setArtifactId(name);
        }
        mavenDependency.setVersion(this.mapToMavenSyntax(dependency.getVersion()));
        mavenDependency.setType(type);
        mavenDependency.setScope(scope);
        mavenDependency.setOptional(false);
        mavenDependency.setClassifier(classifier);
        mavenDependency.setExclusions(this.getExclusions(dependency, configurations));
        return mavenDependency;
    }

    private String mapToMavenSyntax(String version) {
        return this.versionRangeMapper.map(version);
    }

    protected String determineProjectDependencyArtifactId(ProjectDependency dependency) {
        return new ProjectDependencyArtifactIdExtractorHack(dependency).extract();
    }

    private List<Exclusion> getExclusions(ModuleDependency dependency, Set<Configuration> configurations) {
        ArrayList<Exclusion> mavenExclusions = new ArrayList<Exclusion>();
        HashSet excludeRules = new HashSet(dependency.getExcludeRules());
        for (Configuration configuration : configurations) {
            excludeRules.addAll(configuration.getExcludeRules());
        }
        for (ExcludeRule excludeRule : excludeRules) {
            Exclusion mavenExclusion = (Exclusion)this.excludeRuleConverter.convert(excludeRule);
            if (mavenExclusion == null) continue;
            mavenExclusions.add(mavenExclusion);
        }
        return mavenExclusions;
    }

    public ExcludeRuleConverter getExcludeRuleConverter() {
        return this.excludeRuleConverter;
    }
}

