/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.net.URI;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.publication.maven.internal.action.MavenDeployAction;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publication.maven.internal.wagon.RepositoryTransportDeployWagon;
import org.gradle.api.publication.maven.internal.wagon.RepositoryTransportWagonAdapter;
import org.gradle.api.publication.maven.internal.wagon.WagonRegistry;
import org.gradle.api.publish.maven.internal.publisher.AbstractMavenPublisher;
import org.gradle.internal.Factory;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRemotePublisher
extends AbstractMavenPublisher {
    private final Factory<File> temporaryDirFactory;
    private final RepositoryTransportFactory repositoryTransportFactory;

    public MavenRemotePublisher(Factory<LoggingManagerInternal> loggingManagerFactory, LocalMavenRepositoryLocator mavenRepositoryLocator, Factory<File> temporaryDirFactory, RepositoryTransportFactory repositoryTransportFactory) {
        super(loggingManagerFactory, mavenRepositoryLocator);
        this.temporaryDirFactory = temporaryDirFactory;
        this.repositoryTransportFactory = repositoryTransportFactory;
    }

    @Override
    protected MavenPublishAction createDeployTask(File pomFile, LocalMavenRepositoryLocator mavenRepositoryLocator, MavenArtifactRepository artifactRepository) {
        GradleWagonMavenDeployAction deployTask = new GradleWagonMavenDeployAction(pomFile, artifactRepository, this.repositoryTransportFactory);
        deployTask.setLocalMavenRepositoryLocation((File)this.temporaryDirFactory.create());
        deployTask.setRepositories(this.createMavenRemoteRepository(artifactRepository), null);
        deployTask.setUniqueVersion(true);
        return deployTask;
    }

    private RemoteRepository createMavenRemoteRepository(MavenArtifactRepository repository) {
        RemoteRepository remoteRepository = new RemoteRepository();
        remoteRepository.setUrl(repository.getUrl().toString());
        return remoteRepository;
    }

    private static class GradleWagonMavenDeployAction
    extends MavenDeployAction {
        private final MavenArtifactRepository artifactRepository;
        private final RepositoryTransportFactory repositoryTransportFactory;
        private final WagonRegistry wagonRegistry;

        public GradleWagonMavenDeployAction(File pomFile, MavenArtifactRepository artifactRepository, RepositoryTransportFactory repositoryTransportFactory) {
            super(pomFile);
            this.artifactRepository = artifactRepository;
            this.repositoryTransportFactory = repositoryTransportFactory;
            this.wagonRegistry = new WagonRegistry(this.getContainer());
            this.registerWagonProtocols();
        }

        private void registerWagonProtocols() {
            for (String protocol : this.repositoryTransportFactory.getRegisteredProtocols()) {
                this.wagonRegistry.registerProtocol(protocol);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish() {
            String protocol = this.artifactRepository.getUrl().getScheme().toLowerCase();
            RepositoryTransportWagonAdapter adapter = this.createAdapter(protocol, this.artifactRepository, this.repositoryTransportFactory);
            RepositoryTransportDeployWagon.contextualize(adapter);
            try {
                super.publish();
            }
            finally {
                RepositoryTransportDeployWagon.decontextualize();
            }
        }

        private RepositoryTransportWagonAdapter createAdapter(String protocol, MavenArtifactRepository artifactRepository, RepositoryTransportFactory repositoryTransportFactory) {
            Credentials credentials = ((AuthenticationSupportedInternal)artifactRepository).getConfiguredCredentials();
            RepositoryTransport transport = repositoryTransportFactory.createTransport(protocol, artifactRepository.getName(), credentials);
            URI rootUri = artifactRepository.getUrl();
            return new RepositoryTransportWagonAdapter(transport, rootUri);
        }
    }
}

