/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.repository.local.LocalSdk;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.android.util.ValueResourcesFileParser;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.incremental.java.FormsParsing;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class AndroidBuildDataCache {
    private static AndroidBuildDataCache ourInstance;
    private final List<LocalSdk> myLocalSdks = Lists.newArrayList();
    private final Map<JpsModule, MyAndroidDeps> myModule2AndroidDeps = new HashMap();
    private final Map<String, List<ResourceEntry>> myParsedValueResourceFiles = new HashMap();

    public static AndroidBuildDataCache getInstance() {
        if (ourInstance == null) {
            ourInstance = new AndroidBuildDataCache();
        }
        return ourInstance;
    }

    public static void clean() {
        ourInstance = null;
    }

    public List<ResourceEntry> getParsedValueResourceFile(File file) throws IOException {
        String path = FileUtil.toCanonicalPath((String)file.getPath());
        List<ResourceEntry> entries = this.myParsedValueResourceFiles.get(path);
        if (entries == null) {
            entries = AndroidBuildDataCache.parseValueResourceFile(file);
            this.myParsedValueResourceFiles.put(path, entries);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ResourceEntry> parseValueResourceFile(File valueResXmlFile) throws IOException {
        final ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(valueResXmlFile));
        try {
            FormsParsing.parse((InputStream)inputStream, (IXMLBuilder)new ValueResourcesFileParser(){

                protected void stop() {
                    throw new FormsParsing.ParserStoppedException();
                }

                protected void process(ResourceEntry resourceEntry) {
                    result.add(resourceEntry);
                }
            });
        }
        finally {
            ((InputStream)inputStream).close();
        }
        return result;
    }

    public List<JpsAndroidModuleExtension> getAllAndroidDependencies(JpsModule module, boolean librariesOnly) {
        MyAndroidDeps deps = this.myModule2AndroidDeps.get(module);
        if (deps == null) {
            deps = AndroidBuildDataCache.computeAndroidDependencies(module);
            this.myModule2AndroidDeps.put(module, deps);
        }
        return librariesOnly ? deps.myLibAndroidDeps : deps.myAndroidDeps;
    }

    private static MyAndroidDeps computeAndroidDependencies(JpsModule module) {
        MyAndroidDeps result = new MyAndroidDeps();
        boolean recursively = AndroidJpsUtil.shouldProcessDependenciesRecursively(module);
        AndroidBuildDataCache.collectAndroidDependencies(module, result, (Set<String>)new HashSet(), true, recursively);
        Collections.reverse(result.myAndroidDeps);
        Collections.reverse(result.myLibAndroidDeps);
        return result;
    }

    private static void collectAndroidDependencies(JpsModule module, MyAndroidDeps result, Set<String> visitedSet, boolean fillLibs, boolean recursively) {
        ArrayList dependencies = new ArrayList(JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, false));
        for (int i = dependencies.size() - 1; i >= 0; --i) {
            JpsAndroidModuleExtension depExtension;
            JpsModule depModule;
            JpsDependencyElement item = (JpsDependencyElement)dependencies.get(i);
            if (!(item instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)item).getModule()) == null || (depExtension = AndroidJpsUtil.getExtension(depModule)) == null || !visitedSet.add(depModule.getName())) continue;
            if (recursively) {
                boolean newRecursively = AndroidJpsUtil.shouldProcessDependenciesRecursively(depModule);
                AndroidBuildDataCache.collectAndroidDependencies(depModule, result, visitedSet, fillLibs && depExtension.isLibrary(), newRecursively);
            }
            result.myAndroidDeps.add(depExtension);
            if (!fillLibs || !depExtension.isLibrary()) continue;
            result.myLibAndroidDeps.add(depExtension);
        }
    }

    public LocalSdk getSdk(File androidSdkHomePath) {
        for (LocalSdk sdk : this.myLocalSdks) {
            if (!FileUtil.filesEqual((File)sdk.getLocation(), (File)androidSdkHomePath)) continue;
            return sdk;
        }
        LocalSdk newSdk = new LocalSdk(androidSdkHomePath);
        this.myLocalSdks.add(0, newSdk);
        return newSdk;
    }

    private static class MyAndroidDeps {
        final List<JpsAndroidModuleExtension> myAndroidDeps = new ArrayList<JpsAndroidModuleExtension>();
        final List<JpsAndroidModuleExtension> myLibAndroidDeps = new ArrayList<JpsAndroidModuleExtension>();

        private MyAndroidDeps() {
        }
    }

    public static class ComputationException
    extends Exception {
        public ComputationException(String message) {
            super(message);
        }
    }

    private static class ErrorComputedValue<T>
    extends MyComputedValue<T> {
        private final String myMessage;

        private ErrorComputedValue(String message) {
            this.myMessage = message;
        }

        @Override
        T getValue() throws ComputationException {
            throw new ComputationException(this.myMessage);
        }
    }

    private static class SuccessComputedValue<T>
    extends MyComputedValue<T> {
        private final T myValue;

        private SuccessComputedValue(T value) {
            this.myValue = value;
        }

        @Override
        T getValue() throws ComputationException {
            return this.myValue;
        }
    }

    private static abstract class MyComputedValue<T> {
        private MyComputedValue() {
        }

        abstract T getValue() throws ComputationException;
    }
}

