/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

public class AndroidExcludedJavaSourceRootProvider
extends ExcludedJavaSourceRootProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidExcludedJavaSourceRootProvider");

    public boolean isExcludedFromCompilation(JpsModule module, JpsModuleSourceRoot root) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        if (extension == null) {
            return false;
        }
        try {
            for (String genDir : AndroidJpsUtil.getGenDirs(extension)) {
                if (!FileUtil.pathsEqual((String)genDir, (String)root.getFile().getPath())) continue;
                return true;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return false;
    }
}

