/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.local.LocalSdk;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdk;

public class AndroidPlatform {
    private final JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> mySdk;
    private final IAndroidTarget myTarget;
    private final int myPlatformToolsRevision;
    private final int mySdkToolsRevision;
    private final LocalSdk myLocalSdk;

    public AndroidPlatform(JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk, IAndroidTarget target, LocalSdk localSdk) {
        this.mySdk = sdk;
        this.myTarget = target;
        String homePath = sdk.getHomePath();
        this.myPlatformToolsRevision = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"platform-tools");
        this.mySdkToolsRevision = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"tools");
        this.myLocalSdk = localSdk;
    }

    public JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getSdk() {
        return this.mySdk;
    }

    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public int getSdkToolsRevision() {
        return this.mySdkToolsRevision;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return this.myTarget.getVersion().getApiLevel() <= 15;
    }

    public LocalSdk getLocalSdk() {
        return this.myLocalSdk;
    }
}

