/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.android.AndroidDexBuilder;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidPreDexBuildTarget;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidPreDexBuilder
extends AndroidTargetBuilder<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Android Pre Dex";

    protected AndroidPreDexBuilder() {
        super(Collections.singletonList(AndroidPreDexBuildTarget.MyTargetType.INSTANCE));
    }

    public static String getOutputFileNameForExternalJar(File srcFile) {
        String canonicalPath = FileUtil.toCanonicalPath((String)srcFile.getAbsolutePath());
        if (canonicalPath == null) {
            return null;
        }
        if (AndroidBuildTestingManager.getTestingManager() != null) {
            return srcFile.getName();
        }
        int hashCode = canonicalPath.hashCode();
        return FileUtil.getNameWithoutExtension((File)srcFile) + "-" + Integer.toHexString(hashCode) + ".jar";
    }

    @Override
    protected void buildTarget(AndroidPreDexBuildTarget target, DirtyFilesHolder<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget> holder, BuildOutputConsumer outputConsumer, CompileContext context) throws ProjectBuildException, IOException {
        if (!AndroidPreDexBuilder.doBuild(target, holder, outputConsumer, context)) {
            throw new StopBuildException();
        }
    }

    private static boolean doBuild(AndroidPreDexBuildTarget target, DirtyFilesHolder<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget> holder, BuildOutputConsumer outputConsumer, CompileContext context) throws IOException, ProjectBuildException {
        final ArrayList filesToPreDex = new ArrayList();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget>(){

            public boolean apply(AndroidPreDexBuildTarget target, File file, AndroidPreDexBuildTarget.MyRootDescriptor root) throws IOException {
                if (AndroidPreDexBuilder.canBePreDexed(file) && file.isFile()) {
                    filesToPreDex.add(Pair.create((Object)file, (Object)root.getModuleName()));
                }
                return true;
            }
        });
        JpsProject project = target.getProject();
        AndroidPlatform platform = null;
        for (JpsModule module : project.getModules()) {
            if (AndroidJpsUtil.getExtension(module) == null) continue;
            platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
            break;
        }
        if (platform == null) {
            return false;
        }
        if (!filesToPreDex.isEmpty()) {
            File outputDir = target.getOutputFile(context);
            for (Pair pair : filesToPreDex) {
                File outputFile;
                context.checkCanceled();
                File srcFile = (File)pair.getFirst();
                String moduleName = (String)pair.getSecond();
                String srcFilePath = srcFile.getAbsolutePath();
                if (moduleName != null) {
                    context.processMessage((BuildMessage)new ProgressMessage("Pre-dex [" + moduleName + "]"));
                    outputFile = new File(new File(outputDir, moduleName), srcFile.getName());
                } else {
                    context.processMessage((BuildMessage)new ProgressMessage("Pre-dex: " + srcFile.getName()));
                    String outputFileName = AndroidPreDexBuilder.getOutputFileNameForExternalJar(srcFile);
                    if (outputFileName == null) {
                        context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Cannot pre-dex file " + srcFilePath + ": incorrect path", srcFilePath));
                        return false;
                    }
                    outputFile = new File(outputDir, outputFileName);
                }
                if (AndroidJpsUtil.createDirIfNotExist(outputFile.getParentFile(), context, BUILDER_NAME) == null) {
                    return false;
                }
                if (AndroidDexBuilder.runDex(platform, outputFile.getPath(), new String[]{srcFilePath}, context, project, outputConsumer, BUILDER_NAME, srcFile.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canBePreDexed(File file) {
        return "jar".equals(FileUtilRt.getExtension((String)file.getName()));
    }

    public String getPresentableName() {
        return BUILDER_NAME;
    }
}

