/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class AndroidBuildTargetType<T extends AndroidBuildTarget>
extends BuildTargetType<T> {
    private final String myPresentableName;

    AndroidBuildTargetType(String typeId, String presentableName) {
        super(typeId);
        this.myPresentableName = presentableName;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public List<T> computeAllTargets(JpsModel model) {
        if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
            return Collections.emptyList();
        }
        ArrayList<T> targets = new ArrayList<T>();
        for (JpsModule module : model.getProject().getModules()) {
            T target;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null || (target = this.createBuildTarget(extension)) == null) continue;
            targets.add(target);
        }
        return targets;
    }

    public abstract T createBuildTarget(JpsAndroidModuleExtension var1);

    public BuildTargetLoader<T> createLoader(JpsModel model) {
        final HashMap<String, AndroidBuildTarget> targetMap = new HashMap<String, AndroidBuildTarget>();
        for (AndroidBuildTarget target : this.computeAllTargets(model)) {
            targetMap.put(target.getId(), target);
        }
        return new BuildTargetLoader<T>(){

            public T createTarget(String targetId) {
                return (Object)((AndroidBuildTarget)((Object)targetMap.get(targetId)));
            }
        };
    }
}

