/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.android.AndroidDependencyProcessor;
import org.jetbrains.jps.android.AndroidDependencyType;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.AndroidPreDexBuilder;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidClassesDirBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidFileBasedBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidPreDexBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidDexCompilerConfiguration;
import org.jetbrains.jps.android.model.JpsAndroidExtensionService;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidDexBuildTarget
extends AndroidBuildTarget {
    public AndroidDexBuildTarget(JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        super.writeConfiguration(pd, out);
        JpsAndroidDexCompilerConfiguration c = JpsAndroidExtensionService.getInstance().getDexCompilerConfiguration(this.getModule().getProject());
        if (c != null) {
            out.println(c.getVmOptions());
            out.println(c.getMaxHeapSize());
            out.println(c.isOptimize());
            out.println(c.isForceJumbo());
            out.println(c.isCoreLibrary());
            out.println(c.getProguardVmOptions());
        }
    }

    @Override
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File testModuleClassesDir;
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isLibrary()) {
            return Collections.emptyList();
        }
        THashMap libPackage2ModuleName = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        THashSet appClassesDirs = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        THashSet javaClassesDirs = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        THashSet libClassesDirs = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        File moduleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION).getOutputDir();
        if (moduleClassesDir != null) {
            appClassesDirs.add(moduleClassesDir.getPath());
        }
        AndroidJpsUtil.processClasspath(dataPaths, this.myModule, new AndroidDependencyProcessor((Map)libPackage2ModuleName, (Set)libClassesDirs, (Set)javaClassesDirs){
            final /* synthetic */ Map val$libPackage2ModuleName;
            final /* synthetic */ Set val$libClassesDirs;
            final /* synthetic */ Set val$javaClassesDirs;
            {
                this.val$libPackage2ModuleName = map;
                this.val$libClassesDirs = set;
                this.val$javaClassesDirs = set2;
            }

            @Override
            public void processAndroidLibraryPackage(File file, JpsModule depModule) {
                this.val$libPackage2ModuleName.put(file.getPath(), depModule.getName());
            }

            @Override
            public void processAndroidLibraryOutputDirectory(File dir) {
                this.val$libClassesDirs.add(dir.getPath());
            }

            @Override
            public void processJavaModuleOutputDirectory(File dir) {
                this.val$javaClassesDirs.add(dir.getPath());
            }

            @Override
            public boolean isToProcess(AndroidDependencyType type) {
                return type == AndroidDependencyType.ANDROID_LIBRARY_PACKAGE || type == AndroidDependencyType.ANDROID_LIBRARY_OUTPUT_DIRECTORY || type == AndroidDependencyType.JAVA_MODULE_OUTPUT_DIR;
            }
        }, false, false);
        if (extension.isPackTestCode() && (testModuleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.TEST).getOutputDir()) != null) {
            appClassesDirs.add(testModuleClassesDir.getPath());
        }
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (String classesDir : appClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File(classesDir), ClassesDirType.ANDROID_APP));
        }
        for (String classesDir : libClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File(classesDir), ClassesDirType.ANDROID_LIB));
        }
        for (String classesDir : javaClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File(classesDir), ClassesDirType.JAVA));
        }
        File preDexOutputDir = AndroidPreDexBuildTarget.getOutputDir(dataPaths);
        for (Map.Entry entry : libPackage2ModuleName.entrySet()) {
            String libPackage = (String)entry.getKey();
            String moduleName = (String)entry.getValue();
            File libPackageJarFile = new File(libPackage);
            assert (AndroidPreDexBuilder.canBePreDexed(libPackageJarFile));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, libPackageJarFile, true, false));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, new File(new File(preDexOutputDir, moduleName), libPackageJarFile.getName()), true, true));
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(this.myModule, null, null);
        if (platform != null) {
            for (String jarOrLibDir : AndroidJpsUtil.getExternalLibraries(dataPaths, this.myModule, platform, false, false, true)) {
                String preDexedFileName;
                File file;
                File preDexedFile = file = new File(jarOrLibDir);
                if (AndroidPreDexBuilder.canBePreDexed(file) && (preDexedFileName = AndroidPreDexBuilder.getOutputFileNameForExternalJar(file)) != null) {
                    preDexedFile = new File(preDexOutputDir, preDexedFileName);
                }
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, file, false, false));
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, preDexedFile, false, true));
            }
        }
        for (String path : AndroidJpsUtil.getProvidedLibraries(dataPaths, this.myModule)) {
            result.add((BuildRootDescriptor)new MyProvidedJarBuildRootDescriptor(this, new File(path)));
        }
        return result;
    }

    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singletonList(this.getOutputFile(context));
    }

    public File getOutputFile(CompileContext context) {
        return AndroidDexBuildTarget.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths(), this.myModule);
    }

    public static File getOutputFile(BuildDataPaths dataPaths, JpsModule module) {
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        return new File(dir, "classes.dex");
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry registry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList(super.computeDependencies(registry, outputIndex));
        result.add(new AndroidAarDepsBuildTarget(this.myModule));
        result.add(new AndroidPreDexBuildTarget(this.myModule.getProject()));
        return result;
    }

    public static class MyJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        private final boolean myLibPackage;
        private final boolean myPreDexed;

        public MyJarBuildRootDescriptor(BuildTarget target, File file, boolean libPackage, boolean preDexed) {
            super(target, file);
            this.myLibPackage = libPackage;
            this.myPreDexed = preDexed;
        }

        public boolean isLibPackage() {
            return this.myLibPackage;
        }

        public boolean isPreDexed() {
            return this.myPreDexed;
        }
    }

    public static class MyProvidedJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        public MyProvidedJarBuildRootDescriptor(BuildTarget target, File file) {
            super(target, file);
        }
    }

    public static class MyClassesDirBuildRootDescriptor
    extends AndroidClassesDirBuildRootDescriptor {
        private final ClassesDirType myClassesDirType;

        public MyClassesDirBuildRootDescriptor(BuildTarget target, File root, ClassesDirType classesDirType) {
            super(target, root);
            this.myClassesDirType = classesDirType;
        }

        public ClassesDirType getClassesDirType() {
            return this.myClassesDirType;
        }
    }

    public static enum ClassesDirType {
        ANDROID_APP,
        ANDROID_LIB,
        JAVA;

    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidDexBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-dex", "DEX");
        }

        @Override
        public AndroidDexBuildTarget createBuildTarget(JpsAndroidModuleExtension extension) {
            return !extension.isLibrary() ? new AndroidDexBuildTarget(extension.getModule()) : null;
        }
    }
}

