/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidResourceCachingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidResourcePackagingBuildTarget
extends AndroidBuildTarget {
    public AndroidResourcePackagingBuildTarget(JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isUseCustomManifestPackage()) {
            out.println(extension.getCustomManifestPackage());
        }
        out.println(extension.getAdditionalPackagingCommandLineParameters());
    }

    @Override
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        String[] resourceDirs = AndroidJpsUtil.collectResourceDirsForCompilation(extension, true, dataPaths, false);
        ArrayList<String> assertDirs = new ArrayList<String>();
        AndroidResourcePackagingBuildTarget.collectAssetDirs(extension, assertDirs, false);
        File manifestFile = AndroidJpsUtil.getPreprocessedManifestFile(extension, dataPaths);
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (String resourceDir : resourceDirs) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(resourceDir)));
        }
        for (String assetDir : assertDirs) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(assetDir)));
        }
        if (manifestFile != null) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, manifestFile));
        }
        return result;
    }

    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singletonList(this.getOutputFile(context));
    }

    public File getOutputFile(CompileContext context) {
        return AndroidResourcePackagingBuildTarget.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths(), this.myModule);
    }

    public static File getOutputFile(BuildDataPaths dataPaths, JpsModule module) {
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        return new File(dir.getPath(), module.getName() + ".apk.res");
    }

    public static void collectAssetDirs(JpsAndroidModuleExtension extension, List<String> result, boolean checkExistence) {
        File assetsDir = extension.getAssetsDir();
        if (assetsDir != null && (!checkExistence || assetsDir.exists())) {
            result.add(assetsDir.getPath());
        }
        if (extension.isIncludeAssetsFromLibraries()) {
            for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
                File depAssetsDir = depExtension.getAssetsDir();
                if (depAssetsDir == null || checkExistence && !depAssetsDir.exists()) continue;
                result.add(depAssetsDir.getPath());
            }
            AndroidResourcePackagingBuildTarget.collectAssetDirsFromAarDeps(extension.getModule(), result);
        }
    }

    private static void collectAssetDirsFromAarDeps(JpsModule module, Collection<String> result) {
        ArrayList<String> resDirsFromAarDeps = new ArrayList<String>();
        AndroidJpsUtil.collectResDirectoriesFromAarDeps(module, resDirsFromAarDeps);
        if (resDirsFromAarDeps.isEmpty()) {
            return;
        }
        for (String path : resDirsFromAarDeps) {
            File assetsSibling = new File(new File(path).getParentFile(), "assets");
            if (!assetsSibling.isDirectory()) continue;
            result.add(assetsSibling.getPath());
        }
    }

    @Override
    protected void fillDependencies(List<BuildTarget<?>> result) {
        super.fillDependencies(result);
        result.add(new AndroidResourceCachingBuildTarget(this.myModule));
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(this.myModule, true)) {
            result.add(new AndroidResourceCachingBuildTarget(depExtension.getModule()));
        }
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidResourcePackagingBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-resource-packaging", "Resource Packaging");
        }

        @Override
        public AndroidResourcePackagingBuildTarget createBuildTarget(JpsAndroidModuleExtension extension) {
            return !extension.isLibrary() ? new AndroidResourcePackagingBuildTarget(extension.getModule()) : null;
        }
    }
}

