/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;

public class GradleSMTestProxy
extends SMTestProxy {
    private final String myClassName;
    private String myStacktrace;

    public GradleSMTestProxy(String testName, boolean isSuite, String locationUrl, String className) {
        super(testName, isSuite, locationUrl);
        this.myClassName = className;
    }

    public void setTestFailed(String localizedMessage, String stackTrace, boolean testError) {
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestFailed(localizedMessage, stackTrace, testError);
    }

    public void setTestComparisonFailed(String localizedMessage, String stackTrace, String actualText, String expectedText) {
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText);
    }

    public void setTestIgnored(String ignoreComment, String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestIgnored(ignoreComment, stackTrace);
    }

    public Location getLocation(Project project, GlobalSearchScope searchScope) {
        if (this.getLocationUrl() != null && this.isDefect() && this.myStacktrace != null) {
            String[] stackTrace;
            for (String aStackTrace : stackTrace = new LineTokenizer(this.myStacktrace).execute()) {
                StackTraceLine line = new StackTraceLine(project, aStackTrace);
                if (!this.getName().equals(line.getMethodName()) || !StringUtil.equals((CharSequence)this.myClassName, (CharSequence)line.getClassName())) continue;
                return line.getMethodLocation(project);
            }
        }
        return super.getLocation(project, searchScope);
    }

    private void setStacktraceIfNotSet(String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }
}

