/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GradleUrlProvider
implements TestLocationProvider {
    public static final String PROTOCOL_ID = "gradle";
    public static final String METHOD_PREF = "methodName";
    public static final String CLASS_PREF = "className";

    public List<Location> getLocation(String protocolId, String locationData, Project project) {
        if (!PROTOCOL_ID.equals(protocolId)) {
            return Collections.emptyList();
        }
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyList();
        }
        String className = GradleUrlProvider.extractFullClassName(locationData);
        if (className == null) {
            return Collections.emptyList();
        }
        PsiClass testClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (testClass == null) {
            return Collections.emptyList();
        }
        String methodName = GradleUrlProvider.extractMethodName(locationData);
        if (methodName == null) {
            return Collections.singletonList(new PsiLocation(project, (PsiElement)testClass));
        }
        PsiMethod[] methods = testClass.findMethodsByName(methodName, true);
        ArrayList<Location> list = new ArrayList<Location>(methods.length);
        for (PsiMethod method : methods) {
            list.add((Location)new PsiLocation(project, (PsiElement)method));
        }
        return list;
    }

    private static String extractFullClassName(String locationData) {
        int i = locationData.indexOf("::");
        String pref = locationData.substring(0, i);
        String qualifiedName = locationData.substring(i + 2);
        if (METHOD_PREF.equals(pref)) {
            int dot = qualifiedName.lastIndexOf(46);
            return qualifiedName.substring(0, dot);
        }
        if (CLASS_PREF.equals(pref)) {
            return qualifiedName;
        }
        return null;
    }

    private static String extractMethodName(String locationData) {
        int i = locationData.indexOf("::");
        String pref = locationData.substring(0, i);
        String qualifiedName = locationData.substring(i + 2);
        if (METHOD_PREF.equals(pref)) {
            int dot = qualifiedName.lastIndexOf(46);
            return qualifiedName.substring(dot + 1);
        }
        return null;
    }
}

