/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class BuildScriptDataBuilder {
    private final VirtualFile myBuildScriptFile;
    private final Set<String> plugins = ContainerUtil.newTreeSet();
    private final Set<String> repositories = ContainerUtil.newTreeSet();
    private final Set<String> dependencies = ContainerUtil.newTreeSet();
    private final Set<String> properties = ContainerUtil.newTreeSet();
    private final Set<String> other = ContainerUtil.newTreeSet();

    public BuildScriptDataBuilder(VirtualFile buildScriptFile) {
        this.myBuildScriptFile = buildScriptFile;
    }

    public VirtualFile getBuildScriptFile() {
        return this.myBuildScriptFile;
    }

    public String build() {
        ArrayList lines = ContainerUtil.newArrayList();
        Function<String, String> padding = new Function<String, String>(){

            public String fun(String s) {
                return StringUtil.isNotEmpty((String)s) ? "    " + s : "";
            }
        };
        if (!this.plugins.isEmpty()) {
            lines.addAll(this.plugins);
            lines.add("");
        }
        if (!this.properties.isEmpty()) {
            lines.addAll(this.properties);
            lines.add("");
        }
        if (!this.repositories.isEmpty()) {
            lines.add("repositories {");
            lines.addAll(ContainerUtil.map(this.repositories, (Function)padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.dependencies.isEmpty()) {
            lines.add("dependencies {");
            lines.addAll(ContainerUtil.map(this.dependencies, (Function)padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.other.isEmpty()) {
            lines.addAll(this.other);
        }
        return StringUtil.join((Collection)lines, (String)"\n");
    }

    public BuildScriptDataBuilder addPluginDefinition(String definition) {
        this.plugins.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addRepositoriesDefinition(String definition) {
        this.repositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addDependencyNotation(String notation) {
        this.dependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPropertyDefinition(String definition) {
        this.properties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addOther(String definition) {
        this.other.add(definition.trim());
        return this;
    }
}

