/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class BuildScriptClasspathData
extends AbstractExternalEntityData {
    private static final long serialVersionUID = 1L;
    public static final Key<BuildScriptClasspathData> KEY = Key.create(BuildScriptClasspathData.class, (int)(ProjectKeys.LIBRARY_DEPENDENCY.getProcessingWeight() + 1));
    private final List<ClasspathEntry> myClasspathEntries;

    public BuildScriptClasspathData(ProjectSystemId owner, List<ClasspathEntry> classpathEntries) {
        super(owner);
        this.myClasspathEntries = classpathEntries;
    }

    public List<ClasspathEntry> getClasspathEntries() {
        return this.myClasspathEntries;
    }

    public static class ClasspathEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<String> myClassesFile;
        private final Set<String> mySourcesFile;
        private final Set<String> myJavadocFile;

        public ClasspathEntry(Set<String> classesFile, Set<String> sourcesFile, Set<String> javadocFile) {
            this.myClassesFile = classesFile;
            this.mySourcesFile = sourcesFile;
            this.myJavadocFile = javadocFile;
        }

        public Set<String> getClassesFile() {
            return this.myClassesFile;
        }

        public Set<String> getSourcesFile() {
            return this.mySourcesFile;
        }

        public Set<String> getJavadocFile() {
            return this.myJavadocFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClasspathEntry)) {
                return false;
            }
            ClasspathEntry entry = (ClasspathEntry)o;
            if (!((Object)this.myClassesFile).equals(entry.myClassesFile)) {
                return false;
            }
            if (!((Object)this.myJavadocFile).equals(entry.myJavadocFile)) {
                return false;
            }
            return ((Object)this.mySourcesFile).equals(entry.mySourcesFile);
        }

        public int hashCode() {
            int result = ((Object)this.myClassesFile).hashCode();
            result = 31 * result + ((Object)this.mySourcesFile).hashCode();
            result = 31 * result + ((Object)this.myJavadocFile).hashCode();
            return result;
        }
    }
}

