/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;

public class WarDirectory
implements Serializable {
    public static final WarDirectory WAR_ROOT = new WarDirectory("/");
    public static final WarDirectory META_INF = new WarDirectory("/META-INF");
    public static final WarDirectory WEB_INF = new WarDirectory("/WEB-INF");
    public static final WarDirectory WEB_INF_LIB = new WarDirectory("/WEB-INF/lib");
    public static final WarDirectory WEB_INF_CLASSES = new WarDirectory("/WEB-INF/classes");
    private static final WarDirectory[] WAR_DIRECTORIES = new WarDirectory[]{WAR_ROOT, META_INF, WEB_INF, WEB_INF_LIB, WEB_INF_CLASSES};
    private final String myRelativePath;

    WarDirectory(String relativePath) {
        this.myRelativePath = WarDirectory.getAdjustedPath(relativePath);
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    public boolean isCustomDirectory() {
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!this.myRelativePath.equals(warDirectory.getRelativePath())) continue;
            return false;
        }
        return true;
    }

    public static WarDirectory fromPath(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return WAR_ROOT;
        }
        String adjustedPath = WarDirectory.getAdjustedPath(path);
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!warDirectory.myRelativePath.equals(adjustedPath)) continue;
            return warDirectory;
        }
        return new WarDirectory(adjustedPath);
    }

    private static String getAdjustedPath(String path) {
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public String toString() {
        return this.myRelativePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarDirectory directory = (WarDirectory)o;
        return this.myRelativePath.equals(directory.myRelativePath);
    }

    public int hashCode() {
        return this.myRelativePath.hashCode();
    }
}

