/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.remote.impl;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GradleLibraryNamesMixer {
    private static final Map<String, Boolean> NON_UNIQUE_PATH_ENTRIES = new HashMap();
    private static final char NAME_SEPARATOR = '-';

    public void mixNames(Collection<DataNode<LibraryData>> libraries) {
        if (libraries.isEmpty()) {
            return;
        }
        java.util.HashMap names = ContainerUtilRt.newHashMap();
        ArrayList data = ContainerUtilRt.newArrayList();
        for (DataNode<LibraryData> library : libraries) {
            Wrapped wrapped = new Wrapped((LibraryData)library.getData());
            data.add(wrapped);
        }
        boolean mixed = false;
        while (!mixed) {
            mixed = GradleLibraryNamesMixer.doMixNames(data, names);
        }
    }

    private static boolean doMixNames(Collection<Wrapped> libraries, Map<String, Wrapped> cache) {
        cache.clear();
        for (Wrapped current : libraries) {
            Wrapped previous = cache.remove(current.library.getExternalName());
            if (previous == null) {
                cache.put(current.library.getExternalName(), current);
                continue;
            }
            GradleLibraryNamesMixer.mixNames(current, previous);
            return current.library.getExternalName().equals(previous.library.getExternalName());
        }
        return true;
    }

    private static void mixNames(Wrapped wrapped1, Wrapped wrapped2) {
        if (!wrapped1.prepare() || !wrapped2.prepare()) {
            return;
        }
        String wrapped1AltText = null;
        String wrapped2AltText = null;
        File file1 = wrapped1.currentFile;
        for (File file2 = wrapped2.currentFile; file1 != null && file2 != null; file1 = file1.getParentFile(), file2 = file2.getParentFile()) {
            while (file1 != null && !StringUtil.isEmpty((String)file1.getName()) && NON_UNIQUE_PATH_ENTRIES.containsKey(file1.getName())) {
                if (NON_UNIQUE_PATH_ENTRIES.get(file1.getName()).booleanValue()) {
                    wrapped1AltText = StringUtil.isEmpty(wrapped1AltText) ? file1.getName() : wrapped1AltText + '-' + file1.getName();
                }
                file1 = file1.getParentFile();
            }
            while (file2 != null && !StringUtil.isEmpty((String)file2.getName()) && NON_UNIQUE_PATH_ENTRIES.containsKey(file2.getName())) {
                if (NON_UNIQUE_PATH_ENTRIES.get(file2.getName()).booleanValue()) {
                    wrapped2AltText = StringUtil.isEmpty(wrapped2AltText) ? file2.getName() : wrapped2AltText + '-' + file2.getName();
                }
                file2 = file2.getParentFile();
            }
            if (file1 == null) {
                wrapped1.nextFile();
            } else if (!wrapped1.library.getExternalName().startsWith(file1.getName())) {
                wrapped1.library.setExternalName(file1.getName() + '-' + wrapped1.library.getExternalName());
            }
            if (file2 == null) {
                wrapped2.nextFile();
            } else if (!wrapped2.library.getExternalName().startsWith(file2.getName())) {
                wrapped2.library.setExternalName(file2.getName() + '-' + wrapped2.library.getExternalName());
            }
            if (wrapped1.library.getExternalName().equals(wrapped2.library.getExternalName())) {
                if (wrapped1AltText != null) {
                    GradleLibraryNamesMixer.diversifyName(wrapped1AltText, wrapped1, file1);
                    return;
                }
                if (wrapped2AltText != null) {
                    GradleLibraryNamesMixer.diversifyName(wrapped2AltText, wrapped2, file1);
                    return;
                }
            } else {
                return;
            }
            if (file1 != null && file2 != null) continue;
            return;
        }
    }

    private static void diversifyName(String changeText, Wrapped wrapped, File file) {
        String name = wrapped.library.getExternalName();
        int i = file == null ? -1 : name.indexOf(file.getName());
        String newName = i >= 0 ? name.substring(0, i + file.getName().length()) + '-' + changeText + name.substring(i + file.getName().length()) : changeText + '-' + name;
        wrapped.library.setExternalName(newName);
    }

    static {
        NON_UNIQUE_PATH_ENTRIES.put("src", false);
        NON_UNIQUE_PATH_ENTRIES.put("main", false);
        NON_UNIQUE_PATH_ENTRIES.put("test", true);
        NON_UNIQUE_PATH_ENTRIES.put("resources", false);
        NON_UNIQUE_PATH_ENTRIES.put("java", false);
        NON_UNIQUE_PATH_ENTRIES.put("groovy", false);
    }

    private static class Wrapped {
        public final Set<File> files = new HashSet<File>();
        public File currentFile;
        public LibraryData library;

        Wrapped(LibraryData library) {
            this.library = library;
            for (LibraryPathType pathType : LibraryPathType.values()) {
                for (String path : library.getPaths(pathType)) {
                    this.files.add(new File(path));
                }
            }
        }

        public boolean prepare() {
            if (this.currentFile != null) {
                return true;
            }
            return this.nextFile();
        }

        public boolean nextFile() {
            if (this.files.isEmpty()) {
                return false;
            }
            Iterator<File> iterator = this.files.iterator();
            this.currentFile = iterator.next();
            iterator.remove();
            return true;
        }
    }
}

