/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleBuildClasspathManager {
    private final Project myProject;
    private volatile List<VirtualFile> allFilesCache;
    private final AtomicReference<Map<String, List<VirtualFile>>> myClasspathMap = new AtomicReference(new HashMap());

    public GradleBuildClasspathManager(Project project) {
        this.myProject = project;
        this.allFilesCache = ContainerUtil.newArrayList();
    }

    public static GradleBuildClasspathManager getInstance(Project project) {
        return (GradleBuildClasspathManager)ServiceManager.getService((Project)project, GradleBuildClasspathManager.class);
    }

    public void reload() {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
        HashMap map = ContainerUtil.newHashMap();
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        for (ExternalProjectBuildClasspathPojo projectBuildClasspathPojo : localSettings.getProjectBuildClasspath().values()) {
            ArrayList projectBuildClasspath = ContainerUtil.newArrayList();
            for (String path : projectBuildClasspathPojo.getProjectBuildClasspath()) {
                VirtualFile virtualFile = ExternalSystemUtil.findLocalFileByPath((String)path);
                ContainerUtil.addIfNotNull((Collection)projectBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
            }
            for (ExternalModuleBuildClasspathPojo moduleBuildClasspathPojo : projectBuildClasspathPojo.getModulesBuildClasspath().values()) {
                ArrayList moduleBuildClasspath = ContainerUtil.newArrayList((Iterable)projectBuildClasspath);
                for (String path : moduleBuildClasspathPojo.getEntries()) {
                    VirtualFile virtualFile = ExternalSystemUtil.findLocalFileByPath((String)path);
                    ContainerUtil.addIfNotNull((Collection)moduleBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
                }
                map.put(moduleBuildClasspathPojo.getPath(), moduleBuildClasspath);
            }
        }
        this.myClasspathMap.set(map);
        LinkedHashSet<VirtualFile> set = new LinkedHashSet<VirtualFile>();
        for (List<VirtualFile> virtualFiles : this.myClasspathMap.get().values()) {
            set.addAll(virtualFiles);
        }
        this.allFilesCache = ContainerUtil.newArrayList(set);
    }

    public List<VirtualFile> getAllClasspathEntries() {
        this.checkRootsValidity(this.allFilesCache);
        return this.allFilesCache;
    }

    public List<VirtualFile> getModuleClasspathEntries(String externalModulePath) {
        this.checkRootsValidity(this.myClasspathMap.get().get(externalModulePath));
        List<VirtualFile> virtualFiles = this.myClasspathMap.get().get(externalModulePath);
        return virtualFiles == null ? Collections.emptyList() : virtualFiles;
    }

    private void checkRootsValidity(List<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            return;
        }
        if (!virtualFiles.isEmpty()) {
            for (VirtualFile file : virtualFiles) {
                if (file.isValid()) continue;
                this.reload();
                break;
            }
        }
    }
}

