/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractProjectImportErrorHandler {
    public static final String OPEN_GRADLE_SETTINGS = "Please fix the project's Gradle settings.";
    public static final String SET_UP_HTTP_PROXY = "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
    public static final String UNEXPECTED_ERROR_FILE_BUG = "This is an unexpected error. Please file a bug containing the idea.log file.";
    public static final String FIX_GRADLE_VERSION = "Please point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
    public static final Pattern UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN = Pattern.compile("Gradle version .* is required.*");
    public static final Pattern MISSING_METHOD_PATTERN = Pattern.compile("org.gradle.api.internal.MissingMethodException: Could not find method (.*?) .*");
    public static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile("Build file '(.*)' line: ([\\d]+)");
    private static final Pattern ERROR_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)'");
    public static final String EMPTY_LINE = "\n\n";

    public abstract ExternalSystemException getUserFriendlyError(Throwable var1, String var2, String var3);

    public Pair<Throwable, String> getRootCauseAndLocation(Throwable error) {
        Throwable rootCause = error;
        String location = null;
        while (true) {
            if (location == null) {
                location = this.getLocationFrom(rootCause);
            }
            if (rootCause.getCause() == null || rootCause.getCause().getMessage() == null) break;
            rootCause = rootCause.getCause();
        }
        return Pair.create((Object)rootCause, (Object)location);
    }

    public String getLocationFrom(Throwable error) {
        String location;
        String errorToString = error.toString();
        if (errorToString.contains("LocationAwareException") && (location = error.getMessage()) != null && location.startsWith("Build file '")) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    public ExternalSystemException createUserFriendlyError(String msg, String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        String newMsg = msg;
        if (!newMsg.isEmpty() && Character.isLowerCase(newMsg.charAt(0))) {
            newMsg = "Cause: " + newMsg;
        }
        if (!StringUtil.isEmpty((String)location) && (pair = AbstractProjectImportErrorHandler.getErrorLocation(location)) != null) {
            return new LocationAwareExternalSystemException(newMsg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
        }
        return new ExternalSystemException(newMsg, null, quickFixes);
    }

    private static Pair<String, Integer> getErrorLocation(String location) {
        Matcher matcher = ERROR_LOCATION_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            try {
                line = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        matcher = ERROR_IN_FILE_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            return Pair.create((Object)filePath, (Object)-1);
        }
        return null;
    }

    public String parseMissingMethod(String rootCauseText) {
        Matcher matcher = MISSING_METHOD_PATTERN.matcher(rootCauseText);
        return matcher.find() ? matcher.group(1) : null;
    }
}

