/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleAutoImportAware
implements ExternalSystemAutoImportAware {
    public String getAffectedExternalProjectPath(String changedFileOrDirPath, Project project) {
        if (!changedFileOrDirPath.endsWith("gradle")) {
            return null;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemSettings systemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return null;
        }
        HashMap rootPaths = ContainerUtilRt.newHashMap();
        for (ExternalProjectSettings setting : projectsSettings) {
            File rootPath;
            if (setting == null || setting.getExternalProjectPath() == null || (rootPath = new File(setting.getExternalProjectPath())).getParentFile() == null) continue;
            rootPaths.put(rootPath.getParentFile().getAbsolutePath(), setting.getExternalProjectPath());
        }
        for (File f = new File(changedFileOrDirPath).getParentFile(); f != null; f = f.getParentFile()) {
            String dirPath = f.getAbsolutePath();
            String configFilePath = (String)rootPaths.get(dirPath);
            if (!rootPaths.containsKey(dirPath)) continue;
            return configFilePath;
        }
        return null;
    }
}

