/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import java.util.Collection;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class ProjectResolverContext {
    private final ExternalSystemTaskId myExternalSystemTaskId;
    private final String myProjectPath;
    private final GradleExecutionSettings mySettings;
    private final ProjectConnection myConnection;
    private final ExternalSystemTaskNotificationListener myListener;
    private final boolean myIsPreviewMode;
    private ProjectImportAction.AllModels myModels;

    public ProjectResolverContext(ExternalSystemTaskId externalSystemTaskId, String projectPath, GradleExecutionSettings settings, ProjectConnection connection, ExternalSystemTaskNotificationListener listener, boolean isPreviewMode) {
        this.myExternalSystemTaskId = externalSystemTaskId;
        this.myProjectPath = projectPath;
        this.mySettings = settings;
        this.myConnection = connection;
        this.myListener = listener;
        this.myIsPreviewMode = isPreviewMode;
    }

    public ExternalSystemTaskId getExternalSystemTaskId() {
        return this.myExternalSystemTaskId;
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public GradleExecutionSettings getSettings() {
        return this.mySettings;
    }

    public ProjectConnection getConnection() {
        return this.myConnection;
    }

    public ExternalSystemTaskNotificationListener getListener() {
        return this.myListener;
    }

    public boolean isPreviewMode() {
        return this.myIsPreviewMode;
    }

    public ProjectImportAction.AllModels getModels() {
        return this.myModels;
    }

    public void setModels(ProjectImportAction.AllModels models) {
        this.myModels = models;
    }

    public <T> T getExtraProject(Class<T> modelClazz) {
        return (T)this.myModels.getExtraProject(null, modelClazz);
    }

    public <T> T getExtraProject(IdeaModule module, Class<T> modelClazz) {
        return (T)this.myModels.getExtraProject(module, modelClazz);
    }

    public Collection<String> findModulesWithModel(Class modelClazz) {
        return this.myModels.findModulesWithModel(modelClazz);
    }
}

