/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.service.project.wizard.ExternalModuleSettingsStep;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleFrameworksWizardStep;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleWizardStep;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleModuleBuilder
extends AbstractExternalModuleBuilder<GradleProjectSettings> {
    private static final Logger LOG = Logger.getInstance(GradleModuleBuilder.class);
    private static final String TEMPLATE_GRADLE_SETTINGS = "Gradle Settings.gradle";
    private static final String TEMPLATE_GRADLE_SETTINGS_MERGE = "Gradle Settings merge.gradle";
    private static final String TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Build Script with wrapper.gradle";
    private static final String DEFAULT_TEMPLATE_GRADLE_BUILD = "Gradle Build Script.gradle";
    private static final String TEMPLATE_ATTRIBUTE_PROJECT_NAME = "PROJECT_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_PATH = "MODULE_PATH";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR = "MODULE_FLAT_DIR";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_NAME = "MODULE_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_GROUP = "MODULE_GROUP";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_VERSION = "MODULE_VERSION";
    private static final String TEMPLATE_ATTRIBUTE_GRADLE_VERSION = "GRADLE_VERSION";
    private static final Key<BuildScriptDataBuilder> BUILD_SCRIPT_DATA = Key.create((String)"gradle.module.buildScriptData");
    private WizardContext myWizardContext;
    private ProjectData myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private ProjectId myProjectId;
    private String rootProjectPath;

    public GradleModuleBuilder() {
        super(GradleConstants.SYSTEM_ID, (ExternalProjectSettings)new GradleProjectSettings());
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        String contentEntryPath = this.getContentEntryPath();
        if (StringUtil.isEmpty((String)contentEntryPath)) {
            return;
        }
        File contentRootDir = new File(contentEntryPath);
        FileUtilRt.createDirectory((File)contentRootDir);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile modelContentRootDir = fileSystem.refreshAndFindFileByIoFile(contentRootDir);
        if (modelContentRootDir == null) {
            return;
        }
        modifiableRootModel.addContentEntry(modelContentRootDir);
        if (this.myJdk != null) {
            modifiableRootModel.setSdk(this.myJdk);
        } else {
            modifiableRootModel.inheritSdk();
        }
        Project project = modifiableRootModel.getProject();
        this.rootProjectPath = this.myParentProject != null ? this.myParentProject.getLinkedExternalProjectPath() : FileUtil.toCanonicalPath((String)(this.myWizardContext.isCreatingNewProject() ? project.getBasePath() : modelContentRootDir.getPath()));
        assert (this.rootProjectPath != null);
        VirtualFile gradleBuildFile = this.setupGradleBuildFile(modelContentRootDir);
        this.setupGradleSettingsFile(this.rootProjectPath, modelContentRootDir, modifiableRootModel);
        if (gradleBuildFile != null) {
            modifiableRootModel.getModule().putUserData(BUILD_SCRIPT_DATA, (Object)new BuildScriptDataBuilder(gradleBuildFile));
        }
    }

    protected void setupModule(Module module) throws ConfigurationException {
        super.setupModule(module);
        assert (this.rootProjectPath != null);
        VirtualFile buildScriptFile = null;
        BuildScriptDataBuilder buildScriptDataBuilder = GradleModuleBuilder.getBuildScriptData(module);
        try {
            if (buildScriptDataBuilder != null) {
                buildScriptFile = buildScriptDataBuilder.getBuildScriptFile();
                String text = buildScriptDataBuilder.build();
                GradleModuleBuilder.appendToFile(buildScriptFile, "\n" + text);
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception on applying frameworks templates", (Throwable)e);
        }
        final Project project = module.getProject();
        if (this.myWizardContext.isCreatingNewProject()) {
            ((GradleProjectSettings)this.getExternalProjectSettings()).setExternalProjectPath(this.rootProjectPath);
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
            settings.linkProject(this.getExternalProjectSettings());
        } else {
            FileDocumentManager.getInstance().saveAllDocuments();
            final GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)this.getExternalProjectSettings();
            final VirtualFile finalBuildScriptFile = buildScriptFile;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile;
                    if (GradleModuleBuilder.this.myParentProject == null) {
                        gradleProjectSettings.setExternalProjectPath(GradleModuleBuilder.this.rootProjectPath);
                        AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                        settings.linkProject((ExternalProjectSettings)gradleProjectSettings);
                    }
                    ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)GradleModuleBuilder.this.rootProjectPath, (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
                    if (finalBuildScriptFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(finalBuildScriptFile)) != null) {
                        EditorHelper.openInEditor((PsiElement)psiFile);
                    }
                }
            };
            ExternalSystemUtil.invokeLater((Project)project, (ModalityState)ModalityState.NON_MODAL, (Runnable)runnable);
        }
    }

    public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, ModulesProvider modulesProvider) {
        this.myWizardContext = wizardContext;
        return new ModuleWizardStep[]{new GradleModuleWizardStep(this, wizardContext), new ExternalModuleSettingsStep(wizardContext, (AbstractExternalModuleBuilder)this, (AbstractExternalProjectSettingsControl)new GradleProjectSettingsControl((GradleProjectSettings)this.getExternalProjectSettings()))};
    }

    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        GradleFrameworksWizardStep step = new GradleFrameworksWizardStep(context, this);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk instanceof JavaSdkType;
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    private VirtualFile setupGradleBuildFile(VirtualFile modelContentRootDir) throws ConfigurationException {
        VirtualFile file = GradleModuleBuilder.getOrCreateExternalProjectConfigFile(modelContentRootDir.getPath(), "build.gradle");
        if (file != null) {
            String templateName = ((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : DEFAULT_TEMPLATE_GRADLE_BUILD;
            HashMap attributes = ContainerUtil.newHashMap();
            if (this.myProjectId != null) {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_VERSION, this.myProjectId.getVersion());
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_GROUP, this.myProjectId.getGroupId());
                attributes.put(TEMPLATE_ATTRIBUTE_GRADLE_VERSION, GradleVersion.current().getVersion());
            }
            GradleModuleBuilder.saveFile(file, templateName, attributes);
        }
        return file;
    }

    private VirtualFile setupGradleSettingsFile(String rootProjectPath, VirtualFile modelContentRootDir, ModifiableRootModel model) throws ConfigurationException {
        String moduleName;
        VirtualFile file = GradleModuleBuilder.getOrCreateExternalProjectConfigFile(rootProjectPath, "settings.gradle");
        if (file == null) {
            return null;
        }
        String string = moduleName = this.myProjectId == null ? model.getModule().getName() : this.myProjectId.getArtifactId();
        if (this.myWizardContext.isCreatingNewProject() || this.myParentProject == null) {
            String moduleDirName = VfsUtilCore.getRelativePath((VirtualFile)modelContentRootDir, (VirtualFile)file.getParent(), (char)'/');
            HashMap attributes = ContainerUtil.newHashMap();
            String projectName = model.getProject().getName();
            attributes.put(TEMPLATE_ATTRIBUTE_PROJECT_NAME, projectName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, moduleDirName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            GradleModuleBuilder.saveFile(file, TEMPLATE_GRADLE_SETTINGS, attributes);
        } else {
            String flatStructureModulePath;
            char separatorChar = file.getParent() == null || !VfsUtilCore.isAncestor((VirtualFile)file.getParent(), (VirtualFile)modelContentRootDir, (boolean)true) ? (char)'/' : ':';
            String modulePath = VfsUtil.getPath((VirtualFile)file, (VirtualFile)modelContentRootDir, (char)separatorChar);
            HashMap attributes = ContainerUtil.newHashMap();
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            String string2 = flatStructureModulePath = modulePath != null && StringUtil.startsWith((CharSequence)modulePath, (CharSequence)"../") ? StringUtil.trimStart((String)modulePath, (String)"../") : null;
            if (StringUtil.equals(flatStructureModulePath, (CharSequence)modelContentRootDir.getName())) {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR, "true");
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, flatStructureModulePath);
            } else {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, modulePath);
            }
            GradleModuleBuilder.appendToFile(file, TEMPLATE_GRADLE_SETTINGS_MERGE, attributes);
        }
        return file;
    }

    private static void saveFile(VirtualFile file, String templateName, Map templateAttributes) throws ConfigurationException {
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            GradleModuleBuilder.appendToFile(file, templateAttributes != null ? template.getText(templateAttributes) : template.getText());
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on applying template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't apply %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    private static void appendToFile(VirtualFile file, String templateName, Map templateAttributes) throws ConfigurationException {
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            GradleModuleBuilder.appendToFile(file, templateAttributes != null ? template.getText(templateAttributes) : template.getText());
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on appending template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't append %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    private static VirtualFile getOrCreateExternalProjectConfigFile(String parent, String fileName) {
        File file = new File(parent, fileName);
        FileUtilRt.createIfNotExists((File)file);
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    public void setParentProject(ProjectData parentProject) {
        this.myParentProject = parentProject;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public void setInheritGroupId(boolean inheritGroupId) {
        this.myInheritGroupId = inheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setInheritVersion(boolean inheritVersion) {
        this.myInheritVersion = inheritVersion;
    }

    public ProjectId getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(ProjectId projectId) {
        this.myProjectId = projectId;
    }

    public ModuleWizardStep modifySettingsStep(SettingsStep settingsStep) {
        if (settingsStep instanceof ProjectSettingsStep) {
            ProjectSettingsStep projectSettingsStep = (ProjectSettingsStep)settingsStep;
            if (this.myProjectId != null) {
                JTextField moduleNameField = settingsStep.getModuleNameField();
                if (moduleNameField != null) {
                    moduleNameField.setText(this.myProjectId.getArtifactId());
                }
                projectSettingsStep.setModuleName(this.myProjectId.getArtifactId());
            }
            projectSettingsStep.bindModuleSettings();
        }
        return super.modifySettingsStep(settingsStep);
    }

    public static void appendToFile(VirtualFile file, String text) throws IOException {
        String lineSeparator = LoadTextUtil.detectLineSeparator((VirtualFile)file, (boolean)true);
        if (lineSeparator == null) {
            lineSeparator = CodeStyleSettingsManager.getSettings((Project)ProjectManagerEx.getInstanceEx().getDefaultProject()).getLineSeparator();
        }
        String existingText = StringUtil.trimTrailing((String)VfsUtilCore.loadText((VirtualFile)file));
        String content = (StringUtil.isNotEmpty((String)existingText) ? existingText + lineSeparator : "") + StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
        VfsUtil.saveText((VirtualFile)file, (String)content);
    }

    public static BuildScriptDataBuilder getBuildScriptData(Module module) {
        return module == null ? null : (BuildScriptDataBuilder)module.getUserData(BUILD_SCRIPT_DATA);
    }
}

