/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GradleDependenciesContributor
implements GradleMethodContextContributor {
    @Override
    public void process(List<String> methodCallInfo, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (methodCallInfo.isEmpty()) {
            return;
        }
        String methodCall = (String)ContainerUtil.getLastItem(methodCallInfo);
        if (methodCall == null) {
            return;
        }
        if (!StringUtil.equals((CharSequence)methodCall, (CharSequence)"dependencies")) {
            return;
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        if (methodCallInfo.size() == 2) {
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, "org.gradle.api.artifacts.ExternalModuleDependency");
            PsiClass contributorClass = psiManager.findClassWithCache("org.gradle.api.artifacts.dsl.DependencyHandler", place.getResolveScope());
            if (contributorClass == null) {
                return;
            }
            GradleResolverUtil.processMethod(methodCallInfo.get(0), contributorClass, processor, state, place, "add");
        } else if (methodCallInfo.size() == 3) {
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, "org.gradle.api.artifacts.dsl.DependencyHandler", "org.gradle.api.artifacts.ExternalModuleDependency", "org.gradle.api.artifacts.DependencyArtifact", "org.gradle.api.Project");
        } else if (methodCallInfo.size() == 4) {
            PsiClass contributorClass = psiManager.findClassWithCache("org.gradle.api.artifacts.dsl.DependencyHandler", place.getResolveScope());
            if (contributorClass == null) {
                return;
            }
            GradleResolverUtil.processMethod(methodCallInfo.get(0), contributorClass, processor, state, place, "add");
        }
    }
}

